/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.portlet.action;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.renderer.DefaultFragmentRendererContext;
import com.liferay.fragment.renderer.FragmentPortletRenderer;
import com.liferay.fragment.renderer.FragmentRendererContext;
import com.liferay.fragment.renderer.FragmentRendererController;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.util.FragmentPortletSetupUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletIdException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "mvc.command.name=/content_layout/add_portlet"}, service={MVCActionCommand.class})
public class AddPortletMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(AddPortletMVCActionCommand.class);
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private FragmentPortletRenderer _fragmentPortletRenderer;
    @Reference
    private FragmentRendererController _fragmentRendererController;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        Layout layout = this._layoutLocalService.getLayout(classPK);
        String portletId = PortletIdCodec.decodePortletName((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId"));
        PortletPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)layout.getGroupId(), (Layout)layout, (String)portletId, (String)"ADD_TO_PAGE");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        try {
            String instanceId = "";
            Portlet portlet = this._portletLocalService.getPortletById(portletId);
            if (portlet.isInstanceable()) {
                instanceId = PortletIdCodec.generateInstanceId();
            } else if (this._portletPreferencesLocalService.getPortletPreferencesCount(3, layout.getPlid(), portletId) > 0L) {
                throw new PortletIdException("Cannot add non-instanceable portlet more than once");
            }
            String html = this._getPortletFragmentEntryLinkHTML(serviceContext.getRequest(), this._portal.getHttpServletResponse((PortletResponse)actionResponse), portletId, instanceId);
            JSONObject editableValueJSONObject = this._fragmentEntryProcessorRegistry.getDefaultEditableValuesJSONObject(html);
            editableValueJSONObject.put("instanceId", instanceId).put("portletId", portletId);
            FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, 0L, classNameId, classPK, "", html, "", editableValueJSONObject.toString(), "", 0, null, serviceContext);
            DefaultFragmentRendererContext defaultFragmentRendererContext = new DefaultFragmentRendererContext(fragmentEntryLink);
            defaultFragmentRendererContext.setMode("EDIT");
            jsonObject.put("content", this._fragmentRendererController.render((FragmentRendererContext)defaultFragmentRendererContext, this._portal.getHttpServletRequest((PortletRequest)actionRequest), this._portal.getHttpServletResponse((PortletResponse)actionResponse))).put("editableValues", fragmentEntryLink.getEditableValues());
            if (SessionErrors.contains((PortletRequest)actionRequest, (String)"fragmentEntryInvalidContent")) {
                jsonObject.put("error", true);
            }
            jsonObject.put("fragmentEntryLinkId", fragmentEntryLink.getFragmentEntryLinkId()).put("name", this._portal.getPortletTitle(portletId, themeDisplay.getLocale()));
            SessionMessages.add((PortletRequest)actionRequest, (String)"fragmentEntryLinkAdded");
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            String errorMessage = "an-unexpected-error-occurred";
            jsonObject.put("error", LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)errorMessage));
        }
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    private String _getPortletFragmentEntryLinkHTML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String portletId, String instanceId) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)httpServletRequest, (String)portletId);
        FragmentPortletSetupUtil.setPortletBareboneCSSClassName((PortletPreferences)portletPreferences);
        return this._fragmentPortletRenderer.renderPortlet(httpServletRequest, httpServletResponse, portletId, instanceId, PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences));
    }
}

