/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.portlet.action;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.exception.NoSuchEntryException;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLinkService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "mvc.command.name=/content_layout/add_fragment_entry_link"}, service={MVCActionCommand.class})
public class AddFragmentEntryLinkMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(AddFragmentEntryLinkMVCActionCommand.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private FragmentCollectionContributorTracker _fragmentCollectionContributorTracker;
    @Reference
    private FragmentEntryLinkService _fragmentEntryLinkService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private FragmentRendererTracker _fragmentRendererTracker;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    protected FragmentEntryLink addFragmentEntryLink(ActionRequest actionRequest) throws PortalException {
        String fragmentEntryKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"fragmentKey");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        FragmentEntry fragmentEntry = this._getFragmentEntry(serviceContext, fragmentEntryKey);
        FragmentRenderer fragmentRenderer = this._fragmentRendererTracker.getFragmentRenderer(fragmentEntryKey);
        if (fragmentEntry == null && fragmentRenderer == null) {
            throw new NoSuchEntryException();
        }
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        FragmentEntryLink fragmentEntryLink = null;
        if (fragmentEntry != null) {
            String contributedRendererKey = null;
            if (fragmentEntry.getFragmentEntryId() == 0L) {
                contributedRendererKey = fragmentEntryKey;
            }
            fragmentEntryLink = this._fragmentEntryLinkService.addFragmentEntryLink(serviceContext.getScopeGroupId(), 0L, fragmentEntry.getFragmentEntryId(), classNameId, classPK, fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), null, "", 0, contributedRendererKey, serviceContext);
        } else {
            fragmentEntryLink = this._fragmentEntryLinkService.addFragmentEntryLink(serviceContext.getScopeGroupId(), 0L, 0L, classNameId, classPK, "", "", "", "", "", 0, fragmentEntryKey, serviceContext);
        }
        long segmentsExperienceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"segmentsExperienceId", (long)0L);
        String data = ParamUtil.getString((PortletRequest)actionRequest, (String)"data");
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructure(serviceContext.getScopeGroupId(), classNameId, classPK, segmentsExperienceId, data);
        return fragmentEntryLink;
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AddFragmentEntryLinkCallable callable = new AddFragmentEntryLinkCallable(actionRequest);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)callable);
            jsonObject.put("editableValues", fragmentEntryLink.getEditableValues()).put("fragmentEntryLinkId", fragmentEntryLink.getFragmentEntryLinkId());
            SessionMessages.add((PortletRequest)actionRequest, (String)"fragmentEntryLinkAdded");
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
            String errorMessage = "an-unexpected-error-occurred";
            if (t.getCause() instanceof NoSuchEntryException) {
                errorMessage = "the-fragment-can-no-longer-be-added-because-it-has-been-deleted";
            }
            jsonObject.put("error", LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)errorMessage));
        }
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    private FragmentEntry _getContributedFragmentEntry(String fragmentEntryKey) {
        Map fragmentEntries = this._fragmentCollectionContributorTracker.getFragmentEntries();
        return (FragmentEntry)fragmentEntries.get(fragmentEntryKey);
    }

    private FragmentEntry _getFragmentEntry(ServiceContext serviceContext, String fragmentEntryKey) {
        FragmentEntry fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(serviceContext.getScopeGroupId(), fragmentEntryKey);
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        return this._getContributedFragmentEntry(fragmentEntryKey);
    }

    private class AddFragmentEntryLinkCallable
    implements Callable<FragmentEntryLink> {
        private final ActionRequest _actionRequest;

        @Override
        public FragmentEntryLink call() throws Exception {
            return AddFragmentEntryLinkMVCActionCommand.this.addFragmentEntryLink(this._actionRequest);
        }

        private AddFragmentEntryLinkCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

