/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.model.listener;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplate;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplateManager;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Iterator;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class FragmentEntryLinkModelListener
extends BaseModelListener<FragmentEntryLink> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    @Reference
    private DDMTemplateManager _ddmTemplateManager;
    @Reference
    private Portal _portal;

    public void onAfterRemove(FragmentEntryLink fragmentEntryLink) throws ModelListenerException {
        this._assetEntryUsageLocalService.deleteAssetEntryUsages(this._portal.getClassNameId(FragmentEntryLink.class), String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()), fragmentEntryLink.getClassPK());
        this._ddmTemplateLinkLocalService.deleteTemplateLink(this._portal.getClassNameId(FragmentEntryLink.class), fragmentEntryLink.getFragmentEntryLinkId());
    }

    public void onAfterUpdate(FragmentEntryLink fragmentEntryLink) throws ModelListenerException {
        this._assetEntryUsageLocalService.deleteAssetEntryUsages(this._portal.getClassNameId(FragmentEntryLink.class), String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()), fragmentEntryLink.getClassPK());
        this._ddmTemplateLinkLocalService.deleteTemplateLink(this._portal.getClassNameId(FragmentEntryLink.class), fragmentEntryLink.getFragmentEntryLinkId());
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
            Iterator keysIterator = jsonObject.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                JSONObject editableProcessorJSONObject = jsonObject.getJSONObject(key);
                if (editableProcessorJSONObject == null) continue;
                Iterator editableKeysIterator = editableProcessorJSONObject.keys();
                while (editableKeysIterator.hasNext()) {
                    String fieldId;
                    String editableKey = (String)editableKeysIterator.next();
                    JSONObject editableJSONObject = editableProcessorJSONObject.getJSONObject(editableKey);
                    String mappedField = editableJSONObject.getString("mappedField", fieldId = editableJSONObject.getString("fieldId"));
                    if (Validator.isNotNull((String)mappedField)) {
                        this._updateDDMTemplateLink(fragmentEntryLink, mappedField);
                    }
                    long classPK = GetterUtil.getLong((Object)editableJSONObject.getLong("classPK"));
                    long classNameId = GetterUtil.getLong((Object)editableJSONObject.getLong("classNameId"));
                    this._updateAssetEntryUsage(fragmentEntryLink, classNameId, classPK);
                }
            }
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
    }

    private void _updateAssetEntryUsage(FragmentEntryLink fragmentEntryLink, long classNameId, long classPK) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        if (assetEntry == null) {
            return;
        }
        AssetEntryUsage assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(FragmentEntryLink.class), String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()), fragmentEntryLink.getClassPK());
        if (assetEntryUsage != null) {
            return;
        }
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        this._assetEntryUsageLocalService.addAssetEntryUsage(fragmentEntryLink.getGroupId(), assetEntry.getEntryId(), this._portal.getClassNameId(FragmentEntryLink.class), String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()), fragmentEntryLink.getClassPK(), serviceContext);
    }

    private void _updateDDMTemplateLink(FragmentEntryLink fragmentEntryLink, String mappedField) {
        if (mappedField.startsWith("ddmTemplate_")) {
            String ddmTemplateKey = mappedField.substring("ddmTemplate_".length());
            DDMTemplate ddmTemplate = this._ddmTemplateManager.fetchTemplate(fragmentEntryLink.getGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
            if (ddmTemplate != null) {
                this._ddmTemplateLinkLocalService.addTemplateLink(this._portal.getClassNameId(FragmentEntryLink.class), fragmentEntryLink.getFragmentEntryLinkId(), ddmTemplate.getTemplateId());
            }
        }
    }
}

