/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.content.page.editor.web.internal.editor.configuration;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.DownloadURLItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"editor.config.key=fragmenEntryLinkRichTextEditor", "javax.portlet.name=com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet"}, service={EditorConfigContributor.class})
public class FragmentEntryLinkRichTextEditorConfigContributor
extends BaseEditorConfigContributor {
    @Reference
    private ItemSelector _itemSelector;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.frontend.editor.lang)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        StringBundler sb = new StringBundler(5);
        sb.append(this.getAllowedContentText());
        sb.append(" a[*](*); div[*](*){text-align}; img[*](*){*}; p[*](*); ");
        sb.append(this.getAllowedContentLists());
        sb.append(this.getAllowedContentTable());
        sb.append(" span[*](*){*}; ");
        jsonObject.put("allowedContent", sb.toString()).put("enterMode", 2).put("extraPlugins", this.getExtraPluginsLists());
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, "_EDITOR_NAME_selectItem", new ItemSelectorCriterion[]{this.getImageItemSelectorCriterion(), this.getURLItemSelectorCriterion()});
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL.toString()).put("filebrowserImageBrowseUrl", itemSelectorURL.toString()).put("removePlugins", this.getRemovePluginsLists()).put("spritemap", themeDisplay.getPathThemeImages() + "/lexicon/icons.svg").put("toolbars", this.getToolbarsJSONObject(themeDisplay.getLocale()));
    }

    protected String getAllowedContentLists() {
        return "li ol ul [*](*){*};";
    }

    protected String getAllowedContentTable() {
        return "table[border, cellpadding, cellspacing] {width}; tbody td th[scope]; thead tr[scope];";
    }

    protected String getAllowedContentText() {
        return "b code em h1 h2 h3 h4 h5 h6 hr i p pre strong u [*](*){*};";
    }

    protected String getExtraPluginsLists() {
        return "ae_autolink,ae_dragresize,ae_addimages,ae_imagealignment,ae_placeholder,ae_selectionregion,ae_tableresize,ae_tabletools,ae_uicore,itemselector,media,adaptivemedia";
    }

    protected ItemSelectorCriterion getImageItemSelectorCriterion() {
        ImageItemSelectorCriterion itemSelectorCriterion = new ImageItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new DownloadURLItemSelectorReturnType()});
        return itemSelectorCriterion;
    }

    protected String getRemovePluginsLists() {
        return "contextmenu,elementspath,floatingspace,image,link,liststyle,magicline,resize,tabletools,toolbar,ae_embed";
    }

    protected JSONObject getStyleFormatJSONObject(String styleFormatName, String element, String cssClass, int type) {
        return JSONUtil.put((String)"name", (Object)styleFormatName).put("style", this.getStyleJSONObject(element, cssClass, type));
    }

    protected JSONArray getStyleFormatsJSONArray(Locale locale) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ResourceBundle resourceBundle = null;
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleUtil.getResourceBundleLoader((String)"content.Language", (ClassLoader)clazz.getClassLoader()), this._resourceBundleLoader, LanguageUtil.getPortalResourceBundleLoader()});
        try {
            resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
        }
        catch (MissingResourceException mre) {
            resourceBundle = ResourceBundleUtil.EMPTY_RESOURCE_BUNDLE;
        }
        return JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"small"), "p", "small", 1), this.getStyleFormatJSONObject(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"lead"), "p", "lead", 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"1"), "h1", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"2"), "h2", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"3"), "h3", null, 1), this.getStyleFormatJSONObject(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"heading-x", (Object)"4"), "h4", null, 1)});
    }

    protected JSONObject getStyleFormatsJSONObject(Locale locale) {
        return JSONUtil.put((String)"cfg", (Object)JSONUtil.put((String)"styles", (Object)this.getStyleFormatsJSONArray(locale))).put("name", "styles");
    }

    protected JSONObject getStyleJSONObject(String element, String cssClass, int type) {
        JSONObject styleJSONObject = JSONFactoryUtil.createJSONObject();
        if (Validator.isNotNull((String)cssClass)) {
            styleJSONObject.put("attributes", JSONUtil.put((String)"class", (Object)cssClass));
        }
        styleJSONObject.put("element", element).put("type", type);
        return styleJSONObject;
    }

    protected JSONObject getToolbarsJSONObject(Locale locale) {
        JSONObject toolbarJSONObject = JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['image', 'hline']")).put("tabIndex", 1);
        return JSONUtil.put((String)"add", (Object)toolbarJSONObject).put("styles", this.getToolbarsStylesJSONObject(locale));
    }

    protected JSONObject getToolbarsStylesJSONObject(Locale locale) {
        return JSONUtil.put((String)"selections", (Object)this.getToolbarsStylesSelectionsJSONArray(locale)).put("tabIndex", 1);
    }

    protected JSONArray getToolbarsStylesSelectionsJSONArray(Locale locale) {
        return JSONUtil.putAll((Object[])new Object[]{this.getToolbarsStylesSelectionsLinkJSONObject(), this.getToolbarsStylesSelectionsTextJSONObject(locale)});
    }

    protected JSONObject getToolbarsStylesSelectionsLinkJSONObject() {
        return JSONUtil.put((String)"buttons", (Object)this.toJSONArray("['linkEditBrowse']")).put("name", "link").put("test", "AlloyEditor.SelectionTest.link");
    }

    protected JSONObject getToolbarsStylesSelectionsTextJSONObject(Locale locale) {
        return JSONUtil.put((String)"buttons", (Object)JSONUtil.putAll((Object[])new Object[]{this.getStyleFormatsJSONObject(locale), "bold", "italic", "underline", "ol", "ul", "linkBrowse", "paragraphLeft", "paragraphCenter", "paragraphRight", "paragraphJustify", "spacing", "color", "removeFormat"})).put("name", "text").put("test", "AlloyEditor.SelectionTest.text");
    }

    protected ItemSelectorCriterion getURLItemSelectorCriterion() {
        URLItemSelectorCriterion itemSelectorCriterion = new URLItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new URLItemSelectorReturnType()});
        return itemSelectorCriterion;
    }
}

