Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/reducers/fragments.es", ['module', 'exports', 'require', 'frontend-js-web', '../utils/FragmentsEditorFetchUtils.es', '../utils/FragmentsEditorGetUtils.es', '../utils/FragmentsEditorUpdateUtils.es', '../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.addFragment = addFragment;
  exports.addFragmentEntryLinkReducer = addFragmentEntryLinkReducer;
  exports.deleteFragmentEntryLinkCommentReducer = deleteFragmentEntryLinkCommentReducer;
  exports.duplicateFragmentEntryLinkReducer = duplicateFragmentEntryLinkReducer;
  exports.getFragmentEntryLinkContent = getFragmentEntryLinkContent;
  exports.moveFragmentEntryLinkReducer = moveFragmentEntryLinkReducer;
  exports.removeFragmentEntryLinkReducer = removeFragmentEntryLinkReducer;
  exports.toggleShowResolvedCommentsReducer = toggleShowResolvedCommentsReducer;
  exports.updateEditableValueReducer = updateEditableValueReducer;
  exports.updateFragmentEntryLinkConfigReducer = updateFragmentEntryLinkConfigReducer;
  exports.updateFragmentEntryLinkCommentReducer = updateFragmentEntryLinkCommentReducer;
  exports.updateFragmentEntryLinkContentReducer = updateFragmentEntryLinkContentReducer;
  exports.updateFragmentEntryLinkSearchOptionsReducer = updateFragmentEntryLinkSearchOptionsReducer;

  var _frontendJsWeb = require("frontend-js-web");

  var _FragmentsEditorFetchUtils = require("../utils/FragmentsEditorFetchUtils.es");

  var _FragmentsEditorGetUtils = require("../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../utils/constants");

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Adds a fragment at the corresponding container in the layout
   * @param {string} fragmentEntryLinkId
   * @param {string} dropTargetBorder
   * @param {string} dropTargetItemId
   * @param {string} dropTargetItemType
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkRowType
   * @private
   * @return {object}
   * @review
   */
  function addFragment(fragmentEntryLinkId, dropTargetBorder, dropTargetItemId, dropTargetItemType, layoutData) {
    var fragmentEntryLinkRowType = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow;
    var nextData = layoutData;

    if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.column) {
      var fragmentColumn = (0, _FragmentsEditorGetUtils.getColumn)(layoutData.structure, dropTargetItemId);
      nextData = _addFragmentToColumn(layoutData, fragmentEntryLinkId, dropTargetItemId, fragmentColumn.fragmentEntryLinkIds.length);
    } else if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
      var _fragmentColumn = (0, _FragmentsEditorGetUtils.getFragmentColumn)(layoutData.structure, dropTargetItemId);

      var position = _getDropFragmentPosition(_fragmentColumn.fragmentEntryLinkIds, dropTargetItemId, dropTargetBorder);

      nextData = _addFragmentToColumn(layoutData, fragmentEntryLinkId, _fragmentColumn.columnId, position);
    } else if (dropTargetItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.row) {
      var _position = (0, _FragmentsEditorGetUtils.getDropRowPosition)(layoutData.structure, dropTargetItemId, dropTargetBorder);

      nextData = _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, _position);
    } else {
      nextData = _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, layoutData.structure.length);
    }

    return nextData;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {object} action.comment
   * @param {string} action.fragmentEntryLinkId
   * @param {string} [action.parentCommentId]
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateFragmentEntryLinkCommentReducer(state, action) {
    var commentId = action.comment.commentId;
    var nextState = state;
    var path = ['fragmentEntryLinks', action.fragmentEntryLinkId, 'comments'];

    if (action.parentCommentId) {
      var parentCommentIndex = nextState.fragmentEntryLinks[action.fragmentEntryLinkId].comments.findIndex(function (comment) {
        return comment.commentId === action.parentCommentId;
      });
      path = [].concat(_toConsumableArray(path), [parentCommentIndex, 'children']);
    }

    nextState = (0, _FragmentsEditorUpdateUtils.updateIn)(nextState, path, function (comments) {
      var nextComments;

      if (comments.find(function (comment) {
        return comment.commentId === commentId;
      })) {
        nextComments = comments.map(function (comment) {
          return comment.commentId === commentId ? _objectSpread({}, action.comment, {
            children: comment.children
          }) : comment;
        });
      } else {
        nextComments = [].concat(_toConsumableArray(comments), [action.comment]);
      }

      return nextComments;
    }, []);
    var hasResolvedComments = Object.values(nextState.fragmentEntryLinks).some(function (fragmentEntryLink) {
      return fragmentEntryLink.comments.some(function (comment) {
        return comment.resolved;
      });
    });

    if (!hasResolvedComments) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['showResolvedComments'], false);
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @return {object}
   * @review
   */

  function toggleShowResolvedCommentsReducer(state) {
    return (0, _FragmentsEditorUpdateUtils.setIn)(state, ['showResolvedComments'], !state.showResolvedComments);
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.fragmentEntryLinkId
   * @param {object} action.comment
   * @return {object}
   * @review
   */

  function deleteFragmentEntryLinkCommentReducer(state, action) {
    var nextState = state;

    var filterComment = function filterComment(comment) {
      return comment.commentId !== action.comment.commentId;
    };

    nextState = (0, _FragmentsEditorUpdateUtils.updateIn)(nextState, ['fragmentEntryLinks', action.fragmentEntryLinkId, 'comments'], function (comments) {
      return comments.filter(filterComment).map(function (comment) {
        return _objectSpread({}, comment, {
          children: (comment.children || []).filter(filterComment)
        });
      });
    }, []);
    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.fragmentEntryKey
   * @param {string} action.fragmentEntryLinkType
   * @param {string} action.fragmentName
   * @param {string} action.groupId
   * @return {object}
   * @review
   */

  function addFragmentEntryLinkReducer(state, action) {
    return new Promise(function (resolve) {
      var fragmentEntryLink = null;
      var nextData = null;
      var nextState = state;

      _addFragmentEntryLink(nextState.addFragmentEntryLinkURL, action.fragmentEntryKey, action.fragmentName, action.groupId, nextState.classNameId, nextState.classPK, nextState.portletNamespace, nextState.segmentsExperienceId).then(function (response) {
        fragmentEntryLink = response;
        nextData = addFragment(fragmentEntryLink.fragmentEntryLinkId, nextState.dropTargetBorder, nextState.dropTargetItemId, nextState.dropTargetItemType, nextState.layoutData, action.fragmentEntryLinkRowType);
        return (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId);
      }).then(function () {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId], fragmentEntryLink);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
        resolve(nextState);
      })["catch"](function () {
        resolve(nextState);
      });
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.fragmentEntryLinkRowType
   * @return {object}
   * @review
   */

  function duplicateFragmentEntryLinkReducer(state, action) {
    var nextState = state;
    var fragmentEntryLink = action.fragmentEntryLink;
    var nextData = nextState.layoutData;
    nextData = _duplicateFragment(action.fragmentEntryLinkId, fragmentEntryLink, action.fragmentEntryLinkRowType, nextData);
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId], fragmentEntryLink);
    return nextState;
  }
  /**
   * @param {string} renderFragmentEntryURL
   * @param {{fragmentEntryLinkId: string}} fragmentEntryLink
   * @param {string} portletNamespace
   * @param {number} segmentsExperienceId
   * @return {Promise<object>}
   * @review
   */

  function getFragmentEntryLinkContent(renderFragmentEntryURL, fragmentEntryLink, portletNamespace, segmentsExperienceId) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "fragmentEntryLinkId"), fragmentEntryLink.fragmentEntryLinkId);
    formData.append("".concat(portletNamespace, "segmentsExperienceId"), segmentsExperienceId);
    return (0, _frontendJsWeb.fetch)(renderFragmentEntryURL, {
      body: formData,
      method: 'POST'
    }).then(function (response) {
      return response.json();
    }).then(function (response) {
      if (!response.content) {
        throw new Error();
      }

      fragmentEntryLink = (0, _FragmentsEditorUpdateUtils.setIn)(fragmentEntryLink, ['content'], response.content);
      fragmentEntryLink = (0, _FragmentsEditorUpdateUtils.setIn)(fragmentEntryLink, ['editableValues'], response.editableValues);
      return (0, _FragmentsEditorUpdateUtils.setIn)(fragmentEntryLink, ['error'], response.error);
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.fragmentEntryLinkRowType
   * @param {string} action.fragmentEntryLinkType
   * @param {string} action.targetBorder
   * @param {string} action.targetItemId
   * @param {string} action.targetItemType
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function moveFragmentEntryLinkReducer(state, action) {
    return new Promise(function (resolve) {
      var nextData = null;
      var nextState = state;
      nextData = _removeFragment(nextState.layoutData, action.fragmentEntryLinkId, action.fragmentEntryLinkRowType);
      nextData = addFragment(action.fragmentEntryLinkId, action.targetBorder, action.targetItemId, action.targetItemType, nextData, action.fragmentEntryLinkRowType);
      (0, _FragmentsEditorFetchUtils.updatePageEditorLayoutData)(nextData, nextState.segmentsExperienceId).then(function (response) {
        if (response.error) {
          throw response.error;
        }

        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], nextData);
        resolve(nextState);
      })["catch"](function () {
        resolve(nextState);
      });
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function removeFragmentEntryLinkReducer(state, action) {
    var fragmentEntryLinkId = action.fragmentEntryLinkId;
    var nextState = state;

    if (nextState.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment && nextState.activeItemId === fragmentEntryLinkId) {
      nextState = _objectSpread({}, nextState, {
        activeItemId: null,
        activeItemType: null
      });
    }

    if (nextState.hoveredItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment && nextState.hoveredItemId === fragmentEntryLinkId) {
      nextState = _objectSpread({}, nextState, {
        hoveredItemId: null,
        hoveredItemType: null
      });
    }

    var fragmentEntryLinkRow = nextState.layoutData.structure[(0, _FragmentsEditorGetUtils.getFragmentRowIndex)(nextState.layoutData.structure, fragmentEntryLinkId)];
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], _removeFragment(nextState.layoutData, fragmentEntryLinkId, fragmentEntryLinkRow.type || _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow));
    nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], _removeFragmentFromHiddenContentFromSearch(nextState.layoutData, fragmentEntryLinkId));

    if (!action.fragmentEntryLinkIsUsedInOtherExperience) {
      nextState = (0, _FragmentsEditorUpdateUtils.updateIn)(nextState, ['fragmentEntryLinks'], function (fragmentEntryLinks) {
        var nextFragmentEntryLinks = _objectSpread({}, fragmentEntryLinks);

        delete nextFragmentEntryLinks[fragmentEntryLinkId];
        return nextFragmentEntryLinks;
      }, {});
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.type
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.editableValues
   * @param {Date} action.date
   * @return {object}
   * @review
   */

  function updateEditableValueReducer(state, action) {
    return (0, _FragmentsEditorUpdateUtils.setIn)(state, ['fragmentEntryLinks', action.fragmentEntryLinkId, 'editableValues'], action.editableValues);
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {object} action.config
   * @param {string} action.editableId
   * @param {string} action.fragmentEntryLinkId
   * @param {string} action.type
   * @return {object}
   * @review
   */

  function updateFragmentEntryLinkConfigReducer(state, action) {
    var nextState = state;
    return new Promise(function (resolve) {
      var config = action.config,
          editableId = action.editableId,
          fragmentEntryLinkId = action.fragmentEntryLinkId;
      var editableValues = nextState.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
      Object.entries(config).forEach(function (entry) {
        var _entry = _slicedToArray(entry, 2),
            key = _entry[0],
            value = _entry[1];

        var keysTreeArray = [_constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, editableId, 'config', key];
        editableValues = (0, _FragmentsEditorUpdateUtils.setIn)(editableValues, keysTreeArray, value);
      });
      var formData = new FormData();
      formData.append("".concat(nextState.portletNamespace, "fragmentEntryLinkId"), fragmentEntryLinkId);
      formData.append("".concat(nextState.portletNamespace, "editableValues"), JSON.stringify(editableValues));
      (0, _frontendJsWeb.fetch)(nextState.editFragmentEntryLinkURL, {
        body: formData,
        method: 'POST'
      }).then(function () {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLinkId, 'editableValues'], editableValues);
        resolve(nextState);
      });
    });
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkContent
   * @param {string} action.fragmentEntryLinkId
   * @return {object}
   * @review
   */

  function updateFragmentEntryLinkContentReducer(state, action) {
    var editableValues = action.editableValues,
        fragmentEntryLinkContent = action.fragmentEntryLinkContent,
        fragmentEntryLinkId = action.fragmentEntryLinkId;
    var nextState = state;
    var fragmentEntryLink = nextState.fragmentEntryLinks[fragmentEntryLinkId];

    if (fragmentEntryLink) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId, 'content'], fragmentEntryLinkContent);

      if (editableValues) {
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['fragmentEntryLinks', fragmentEntryLink.fragmentEntryLinkId, 'editableValues'], editableValues);
      }
    }

    return nextState;
  }
  /**
   * @param {object} state
   * @param {object} action
   * @param {string} action.fragmentEntryLinkId
   * @param {boolean} action.nonIndexable
   * @return {object}
   * @review
   */

  function updateFragmentEntryLinkSearchOptionsReducer(state, action) {
    var fragmentEntryLinkId = action.fragmentEntryLinkId,
        nonIndexable = action.nonIndexable;
    var nextState = state;

    if (nonIndexable) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], _addFragmentToHiddenContentFromSearch(nextState.layoutData, fragmentEntryLinkId));
    } else {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['layoutData'], _removeFragmentFromHiddenContentFromSearch(nextState.layoutData, fragmentEntryLinkId));
    }

    return nextState;
  }
  /**
   * @param {string} addFragmentEntryLinkURL
   * @param {string} fragmentEntryKey
   * @param {string} fragmentName
   * @param {string} classNameId
   * @param {string} classPK
   * @param {string} portletNamespace
   * @return {object}
   * @review
   */

  function _addFragmentEntryLink(addFragmentEntryLinkURL, fragmentEntryKey, fragmentName, groupId, classNameId, classPK, portletNamespace, segmentsExperienceId) {
    var formData = new FormData();
    formData.append("".concat(portletNamespace, "fragmentKey"), fragmentEntryKey);
    formData.append("".concat(portletNamespace, "classNameId"), classNameId);
    formData.append("".concat(portletNamespace, "classPK"), classPK);
    formData.append("".concat(portletNamespace, "groupId"), groupId);
    formData.append("".concat(portletNamespace, "segmentsExperienceId"), segmentsExperienceId);
    return (0, _frontendJsWeb.fetch)(addFragmentEntryLinkURL, {
      body: formData,
      method: 'POST'
    }).then(function (response) {
      return response.json();
    }).then(function (response) {
      if (!response.fragmentEntryLinkId) {
        throw new Error();
      }

      return {
        config: {},
        configuration: response.configuration,
        content: response.content,
        defaultConfigurationValues: response.defaultConfigurationValues,
        editableValues: response.editableValues,
        fragmentEntryKey: fragmentEntryKey,
        fragmentEntryLinkId: response.fragmentEntryLinkId,
        name: fragmentName
      };
    });
  }
  /**
   * Returns a new layoutData with the given fragmentEntryLinkId inserted
   * into a given column at the given position
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} targetColumnId
   * @param {number} position
   * @return {object}
   */

  function _addFragmentToColumn(layoutData, fragmentEntryLinkId, targetColumnId, position) {
    var structure = layoutData.structure;
    var column = (0, _FragmentsEditorGetUtils.getColumn)(structure, targetColumnId);
    var row = structure.find(function (_row) {
      return _row.columns.find(function (_column) {
        return column === _column;
      });
    });
    var columnIndex = row.columns.indexOf(column);
    var rowIndex = structure.indexOf(row);
    return (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns', columnIndex, 'fragmentEntryLinkIds'], function (fragmentEntryLinkIds) {
      return (0, _FragmentsEditorUpdateUtils.add)(fragmentEntryLinkIds, fragmentEntryLinkId, position);
    });
  }
  /**
   * Adds a given fragmentEntryLinkId to hidden content from search.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @return {object} Next layout data
   * @review
   */

  function _addFragmentToHiddenContentFromSearch(layoutData, fragmentEntryLinkId) {
    var nonIndexableFragmentEntryLinkIds = layoutData.nonIndexableFragmentEntryLinkIds;
    var fragmentIndex = -1;

    if (nonIndexableFragmentEntryLinkIds) {
      fragmentIndex = nonIndexableFragmentEntryLinkIds.indexOf(fragmentEntryLinkId);
    }

    var nextData = layoutData;

    if (fragmentIndex === -1) {
      nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['nonIndexableFragmentEntryLinkIds'], function (nonIndexableFragmentEntryLinkIds) {
        return (0, _FragmentsEditorUpdateUtils.add)(nonIndexableFragmentEntryLinkIds, fragmentEntryLinkId, 0);
      }, []);
    }

    return nextData;
  }
  /**
   * Returns a new layoutData with the given fragmentEntryLinkId inserted
   * into a single-column new row. The row will be created at the given position.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} fragmentEntryLinkRowType
   * @param {number} position
   * @return {object}
   */

  function _addSingleFragmentRow(layoutData, fragmentEntryLinkId, fragmentEntryLinkRowType, position) {
    return (0, _FragmentsEditorUpdateUtils.addRow)(['12'], layoutData, position, [fragmentEntryLinkId], fragmentEntryLinkRowType);
  }
  /**
   * Duplicate a fragment inside layoutData
   * @param {string} originalFragmentEntryLinkId
   * @param {object} fragmentEntryLink
   * @param {string} fragmentEntryLinkRowType
   * @param {object} layoutData
   * @private
   * @return {object}
   * @review
   */

  function _duplicateFragment(originalFragmentEntryLinkId, fragmentEntryLink, fragmentEntryLinkRowType, layoutData) {
    var nextData = layoutData;

    if (fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow) {
      var fragmentColumn = (0, _FragmentsEditorGetUtils.getFragmentColumn)(layoutData.structure, originalFragmentEntryLinkId);
      var position = fragmentColumn.fragmentEntryLinkIds.indexOf(originalFragmentEntryLinkId);
      nextData = _addFragmentToColumn(layoutData, fragmentEntryLink.fragmentEntryLinkId, fragmentColumn.columnId, position + 1);
    } else {
      var _position2 = (0, _FragmentsEditorGetUtils.getFragmentRowIndex)(layoutData.structure, originalFragmentEntryLinkId) + 1;

      nextData = _addSingleFragmentRow(layoutData, fragmentEntryLink.fragmentEntryLinkId, fragmentEntryLinkRowType, _position2);
    }

    return nextData;
  }
  /**
   * @param {string[]} fragmentEntryLinkIds
   * @param {string} targetFragmentEntryLinkId
   * @param {FRAGMENTS_EDITOR_ITEM_BORDERS} targetBorder
   * @return {number}
   * @review
   */

  function _getDropFragmentPosition(fragmentEntryLinkIds, targetFragmentEntryLinkId, targetBorder) {
    var position = fragmentEntryLinkIds.length;
    var targetPosition = fragmentEntryLinkIds.indexOf(targetFragmentEntryLinkId);

    if (targetPosition > -1 && targetBorder) {
      if (targetBorder === _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top) {
        position = targetPosition;
      } else {
        position = targetPosition + 1;
      }
    }

    return position;
  }
  /**
   * Removes a given fragmentEntryLinkId from a given layoutData.
   * It does not remove it from fragmentEntryLinks array.
   *
   * If the fragmentEntryLinkRowType is "section", it will remove the whole
   * row (and columns) too.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @param {string} [fragmentEntryLinkRowType=FRAGMENTS_EDITOR_ROW_TYPES.componentRow]
   * @return {object} Next layout data
   * @review
   */

  function _removeFragment(layoutData, fragmentEntryLinkId) {
    var fragmentEntryLinkRowType = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _constants.FRAGMENTS_EDITOR_ROW_TYPES.componentRow;
    var structure = layoutData.structure;
    var column = (0, _FragmentsEditorGetUtils.getFragmentColumn)(structure, fragmentEntryLinkId);
    var row = structure.find(function (_row) {
      return _row.columns.find(function (_column) {
        return column === _column;
      });
    });
    var columnIndex = row.columns.indexOf(column);
    var fragmentIndex = column.fragmentEntryLinkIds.indexOf(fragmentEntryLinkId);
    var rowIndex = structure.indexOf(row);
    var nextData = null;

    if (fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
      nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure'], function (structure) {
        return (0, _FragmentsEditorUpdateUtils.remove)(structure, rowIndex);
      });
    } else {
      nextData = (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['structure', rowIndex, 'columns', columnIndex, 'fragmentEntryLinkIds'], function (fragmentEntryLinkIds) {
        return (0, _FragmentsEditorUpdateUtils.remove)(fragmentEntryLinkIds, fragmentIndex);
      });
    }

    return nextData;
  }
  /**
   * Removes a given fragmentEntryLinkId to hidden content from search.
   *
   * @param {object} layoutData
   * @param {string} fragmentEntryLinkId
   * @return {object} Next layout data
   * @review
   */

  function _removeFragmentFromHiddenContentFromSearch(layoutData, fragmentEntryLinkId) {
    var _layoutData$nonIndexa = layoutData.nonIndexableFragmentEntryLinkIds,
        nonIndexableFragmentEntryLinkIds = _layoutData$nonIndexa === void 0 ? [] : _layoutData$nonIndexa;
    var fragmentIndex = nonIndexableFragmentEntryLinkIds.indexOf(fragmentEntryLinkId);

    if (fragmentIndex !== -1) {
      return (0, _FragmentsEditorUpdateUtils.updateIn)(layoutData, ['nonIndexableFragmentEntryLinkIds'], function (nonIndexableFragmentEntryLinkIds) {
        return (0, _FragmentsEditorUpdateUtils.remove)(nonIndexableFragmentEntryLinkIds, fragmentIndex);
      }, []);
    }

    return layoutData;
  }
  //# sourceMappingURL=fragments.es.js.map
});
//# sourceMappingURL=fragments.es.js.map