Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/sidebar/layouts/utils/SidebarLayoutsDragDrop.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state', '../../../../utils/FragmentsEditorDragDrop.es', '../../../../utils/FragmentsEditorUpdateUtils.es', '../../../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalState = _interopRequireDefault(require("frontend-js-metal-web$metal-state"));

  var _FragmentsEditorDragDrop = require("../../../../utils/FragmentsEditorDragDrop.es");

  var _FragmentsEditorUpdateUtils = require("../../../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../../../utils/constants");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SidebarLayoutsDragDrop
   */
  var SidebarLayoutsDragDrop = /*#__PURE__*/function (_State) {
    _inherits(SidebarLayoutsDragDrop, _State);

    /**
     * @inheritDoc
     * @review
     */
    function SidebarLayoutsDragDrop(config) {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, SidebarLayoutsDragDrop);

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(SidebarLayoutsDragDrop)).call.apply(_getPrototypeOf2, [this, config].concat(args)));

      _this._initializeDragAndDrop();

      return _this;
    }
    /**
     * @inheritDoc
     * @review
     */

    _createClass(SidebarLayoutsDragDrop, [{
      key: "dispose",
      value: function dispose() {
        this._dragDrop.dispose();

        _get(_getPrototypeOf(SidebarLayoutsDragDrop.prototype), "dispose", this).call(this);
      }
      /**
       * Callback that is executed when a layout is being dragged.
       * @param {object} data
       * @param {MouseEvent} data.originalEvent
       * @private
       * @review
       */

    }, {
      key: "_handleDrag",
      value: function _handleDrag(data) {
        var targetItem = data.target;
        (0, _FragmentsEditorUpdateUtils.setDraggingItemPosition)(data.originalEvent);

        if (targetItem && 'layoutRowId' in targetItem.dataset) {
          var mouseY = data.originalEvent.clientY;

          var targetItemRegion = _metalPosition["default"].getRegion(targetItem);

          var nearestBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.bottom;

          if (Math.abs(mouseY - targetItemRegion.top) <= Math.abs(mouseY - targetItemRegion.bottom)) {
            nearestBorder = _constants.FRAGMENTS_EDITOR_ITEM_BORDERS.top;
          }

          this.emit('dragLayout', {
            hoveredRowBorder: nearestBorder,
            hoveredRowId: targetItem.dataset.layoutRowId
          });
        }
      }
      /**
       * Callback that is executed when a drag target is leaved.
       * @private
       * @review
       */

    }, {
      key: "_handleDragEnd",
      value: function _handleDragEnd() {
        this.emit('leaveLayoutTarget');
      }
      /**
       * Callback that is executed when a layout is dropped.
       * @param {!object} data
       * @param {!HTMLElement} data.source
       * @param {!MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDrop",
      value: function _handleDrop(data, event) {
        event.preventDefault();

        if (data.target) {
          this.emit('dropLayout', {
            layoutIndex: data.source.dataset.layoutIndex
          });
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_initializeDragAndDrop",
      value: function _initializeDragAndDrop() {
        this._dragDrop = (0, _FragmentsEditorDragDrop.initializeDragDrop)({
          sources: '.fragments-editor__drag-source--sidebar-layout',
          targets: '.fragments-editor__drop-target--sidebar-layout'
        });

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.DRAG, this._handleDrag.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDrop.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.TARGET_LEAVE, this._handleDragEnd.bind(this));
      }
    }]);

    return SidebarLayoutsDragDrop;
  }(_metalState["default"]);

  var _default = SidebarLayoutsDragDrop;
  exports["default"] = _default;
  //# sourceMappingURL=SidebarLayoutsDragDrop.es.js.map
});
//# sourceMappingURL=SidebarLayoutsDragDrop.es.js.map