Liferay.Loader.define("layout-content-page-editor-web@1.0.139/js/components/fragment_entry_link/FragmentEntryLink.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../floating_toolbar/fragment_configuration/FloatingToolbarFragmentConfigurationPanel.es', '../floating_toolbar/fragment_search/FloatingToolbarFragmentSearchPanel.es', './FragmentEntryLinkContent.es', '../../actions/actions.es', '../../actions/duplicateFragmentEntryLink.es', '../../actions/removeFragmentEntryLinks.es', '../../actions/saveChanges.es', '../../actions/updateActiveItem.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorComponentUtils.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/constants', '../../utils/prefixSegmentsExperienceId.es', '../floating_toolbar/FloatingToolbar.es', './FragmentEntryLink.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEntryLink = exports.ConnectedFragmentEntryLink = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("../floating_toolbar/fragment_configuration/FloatingToolbarFragmentConfigurationPanel.es");

  require("../floating_toolbar/fragment_search/FloatingToolbarFragmentSearchPanel.es");

  require("./FragmentEntryLinkContent.es");

  var _actions = require("../../actions/actions.es");

  var _duplicateFragmentEntryLink2 = require("../../actions/duplicateFragmentEntryLink.es");

  var _removeFragmentEntryLinks = require("../../actions/removeFragmentEntryLinks.es");

  var _saveChanges = require("../../actions/saveChanges.es");

  var _updateActiveItem = require("../../actions/updateActiveItem.es");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../utils/constants");

  var _prefixSegmentsExperienceId = require("../../utils/prefixSegmentsExperienceId.es");

  var _FloatingToolbar = _interopRequireDefault(require("../floating_toolbar/FloatingToolbar.es"));

  var _FragmentEntryLink = _interopRequireDefault(require("./FragmentEntryLink.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * FragmentEntryLink
   * @review
   */
  var FragmentEntryLink = /*#__PURE__*/function (_Component) {
    _inherits(FragmentEntryLink, _Component);

    function FragmentEntryLink() {
      _classCallCheck(this, FragmentEntryLink);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEntryLink).apply(this, arguments));
    }

    _createClass(FragmentEntryLink, [{
      key: "created",

      /**
       * @inheritdoc
       */
      value: function created() {
        this._handleFloatingToolbarButtonClicked = this._handleFloatingToolbarButtonClicked.bind(this);
      }
      /**
       * @inheritdoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._disposeFloatingToolbar();
      }
      /**
       * @inheritdoc
       * @param {object} state
       * @return {object}
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var hoveredPath = (0, _FragmentsEditorGetUtils.getItemPath)(state.hoveredItemId, state.hoveredItemType, state.layoutData.structure);
        return _objectSpread({}, state, {
          _fragmentEntryLinkRowType: state.rowType,
          _fragmentsEditorItemTypes: _constants.FRAGMENTS_EDITOR_ITEM_TYPES,
          _fragmentsEditorRowTypes: _constants.FRAGMENTS_EDITOR_ROW_TYPES,
          _hovered: (0, _FragmentsEditorGetUtils.itemIsInPath)(hoveredPath, state.fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment),
          _showComments: state.sidebarPanels.some(function (sidebarPanel) {
            return sidebarPanel.sidebarPanelId === 'comments';
          })
        });
      }
      /**
       * @inheritdoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.fragmentEntryLinkId === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment) {
          this._createFloatingToolbar();
        } else {
          this._disposeFloatingToolbar();
        }
      }
      /**
       * @inheritdoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        return (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncFragmentEntryLinks",
      value: function syncFragmentEntryLinks() {
        if (this.fragmentEntryLinks[this.fragmentEntryLinkId]) {
          var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
          var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
          var configurationValues = this.fragmentEntryLinks[this.fragmentEntryLinkId].editableValues[_constants.FREEMARKER_FRAGMENT_ENTRY_PROCESSOR];
          this._configuration = this.fragmentEntryLinks[this.fragmentEntryLinkId].configuration;
          this._defaultConfigurationValues = this.fragmentEntryLinks[this.fragmentEntryLinkId].defaultConfigurationValues;

          if (configurationValues) {
            var segmentedConfigurationValues = configurationValues[segmentsExperienceId] || configurationValues[defaultSegmentsExperienceId] || configurationValues;
            this._configurationValues = _objectSpread({}, this._defaultConfigurationValues, {}, segmentedConfigurationValues);
          }
        }
      }
      /**
       * Creates a new instance of the floating toolbar.
       * @private
       */

    }, {
      key: "_createFloatingToolbar",
      value: function _createFloatingToolbar() {
        var config = {
          anchorElement: this.element,
          buttons: this._getFloatingToolbarButtons(),
          events: {
            buttonClicked: this._handleFloatingToolbarButtonClicked
          },
          item: {
            configuration: this._configuration,
            configurationValues: this._configurationValues,
            defaultConfigurationValues: this._defaultConfigurationValues,
            fragmentEntryLinkId: this.fragmentEntryLinkId
          },
          itemId: this.fragmentEntryLinkId,
          itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment,
          portalElement: document.body,
          store: this.store
        };

        if (this._floatingToolbar) {
          this._floatingToolbar.setState(config);
        } else {
          this._floatingToolbar = new _FloatingToolbar["default"](config);
        }
      }
      /**
       * Duplicate this fragmentEntryLink
       * @private
       */

    }, {
      key: "_duplicateFragmentEntryLink",
      value: function _duplicateFragmentEntryLink() {
        this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch((0, _duplicateFragmentEntryLink2.duplicateFragmentEntryLinkAction)(this.fragmentEntryLinkId, this.rowType)).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
      }
      /**
       * Disposes of an existing floating toolbar instance.
       * @private
       */

    }, {
      key: "_disposeFloatingToolbar",
      value: function _disposeFloatingToolbar() {
        if (this._floatingToolbar) {
          this._floatingToolbar.dispose();

          this._floatingToolbar = null;
        }
      }
      /**
       * @private
       * @return {object[]} Floating toolbar buttons
       * @review
       */

    }, {
      key: "_getFloatingToolbarButtons",
      value: function _getFloatingToolbarButtons() {
        var buttons = [];
        var fragmentEntryLink = this.fragmentEntryLinks[this.fragmentEntryLinkId];
        var widget = fragmentEntryLink.portletId && (0, _FragmentsEditorGetUtils.getWidget)(this.widgets, fragmentEntryLink.portletId);

        if (!widget || widget.instanceable) {
          buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.duplicateFragment);
        }

        if (this._shouldShowConfigPanel()) {
          buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.fragmentConfiguration);
        }

        if (this.isContentPage) {
          buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.fragmentSearch);
        }

        return buttons;
      }
      /**
       * Callback executed when an floating toolbar button is clicked
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_handleFloatingToolbarButtonClicked",
      value: function _handleFloatingToolbarButtonClicked(event, data) {
        var panelId = data.panelId;

        if (panelId === _constants.FLOATING_TOOLBAR_BUTTONS.duplicateFragment.panelId) {
          event.preventDefault();

          this._duplicateFragmentEntryLink();
        }
      }
      /**
       * Handle fragment keyup event so it can emit when it
       * should be moved or selected.
       * @param {KeyboardEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentKeyUp",
      value: function _handleFragmentKeyUp(event) {
        if (!this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
          event.stopPropagation();
          var direction = (0, _FragmentsEditorGetUtils.getItemMoveDirection)(event.keyCode);
          var fragmentEntryLinkRowType = event.delegateTarget.dataset.fragmentEntryLinkRowType;

          if (direction) {
            if (fragmentEntryLinkRowType === _constants.FRAGMENTS_EDITOR_ROW_TYPES.sectionRow) {
              (0, _FragmentsEditorUpdateUtils.moveRow)(direction, (0, _FragmentsEditorGetUtils.getFragmentRowIndex)(this.layoutData.structure, this.fragmentEntryLinkId), this.store, this.layoutData.structure);
            } else {
              var column = (0, _FragmentsEditorGetUtils.getFragmentColumn)(this.layoutData.structure, this.fragmentEntryLinkId);
              var fragmentIndex = column.fragmentEntryLinkIds.indexOf(this.fragmentEntryLinkId);
              var targetFragmentEntryLinkId = column.fragmentEntryLinkIds[fragmentIndex + direction];

              if (direction && targetFragmentEntryLinkId) {
                var moveItemPayload = {
                  fragmentEntryLinkId: this.fragmentEntryLinkId,
                  targetBorder: (0, _FragmentsEditorGetUtils.getTargetBorder)(direction),
                  targetItemId: targetFragmentEntryLinkId,
                  targetItemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment
                };
                (0, _FragmentsEditorUpdateUtils.moveItem)(this.store, _actions.MOVE_FRAGMENT_ENTRY_LINK, moveItemPayload);
              }
            }
          }
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleFragmentCommentsButtonClick",
      value: function _handleFragmentCommentsButtonClick() {
        this.store.dispatch((0, _updateActiveItem.updateActiveItemAction)(this.fragmentEntryLinkId, _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment));
        this.store.dispatch({
          type: _actions.UPDATE_SELECTED_SIDEBAR_PANEL_ID,
          value: 'comments'
        });
      }
      /**
       * Callback executed when the fragment remove button is clicked.
       * @param {Object} event
       * @private
       */

    }, {
      key: "_handleFragmentRemoveButtonClick",
      value: function _handleFragmentRemoveButtonClick(event) {
        event.stopPropagation();
        (0, _FragmentsEditorUpdateUtils.removeItem)(this.store, (0, _removeFragmentEntryLinks.removeFragmentEntryLinkAction)(this.fragmentEntryLinkId));
      }
      /**
       * Returns wether the config panel should be shown or not
       * @private
       * @review
       */

    }, {
      key: "_shouldShowConfigPanel",
      value: function _shouldShowConfigPanel() {
        var fieldSetsExist = this._configuration && Array.isArray(this._configuration.fieldSets) && this._configuration.fieldSets.length > 0;
        var fragmentIsActive = this.fragmentEntryLinkId === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
        return fieldSetsExist && fragmentIsActive;
      }
    }]);

    return FragmentEntryLink;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEntryLink = FragmentEntryLink;
  FragmentEntryLink.STATE = {
    /**
     * Fragment Entry Configuration
     * @instance
     * @memberOf FragmentEntryLink
     * @type {object}
     */
    _configuration: _metalState.Config.object().internal(),

    /**
     * Fragment Entry Link Configuration values
     * @instance
     * @memberOf FragmentEntryLink
     * @type {object}
     */
    _configurationValues: _metalState.Config.object().internal(),

    /**
     * Fragment Entry Link Default configuration values
     * @instance
     * @memberOf FragmentEntryLink
     * @type {object}
     */
    _defaultConfigurationValues: _metalState.Config.object().internal(),

    /**
     * Floating toolbar instance for internal use.
     * @default null
     * @instance
     * @memberOf FragmentEntryLink
     * @type {object|null}
     */
    _floatingToolbar: _metalState.Config.internal().value(null),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * Fragment name
     * @default ''
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    name: _metalState.Config.string().value(''),

    /**
     * Row type
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {string}
     */
    rowType: _metalState.Config.string(),

    /**
     * Shows FragmentEntryLink control toolbar
     * @default true
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!bool}
     */
    showControlBar: _metalState.Config.bool().value(true),

    /**
     * CSS class to modify style
     * @default undefined
     * @instance
     * @memberOf FragmentEntryLink
     * @review
     * @type {!string}
     */
    styleModifier: _metalState.Config.string()
  };
  var ConnectedFragmentEntryLink = (0, _ConnectedComponent.getConnectedComponent)(FragmentEntryLink, ['activeItemId', 'activeItemType', 'defaultLanguageId', 'defaultSegmentsExperienceId', 'dropTargetItemId', 'dropTargetItemType', 'dropTargetBorder', 'duplicateFragmentEntryLinkURL', 'fragmentEntryLinks', 'hoveredItemId', 'hoveredItemType', 'imageSelectorURL', 'isContentPage', 'languageId', 'layoutData', 'portletNamespace', 'segmentsExperienceId', 'selectedMappingTypes', 'selectedSidebarPanelId', 'sidebarPanels', 'spritemap', 'widgets']);
  exports.ConnectedFragmentEntryLink = ConnectedFragmentEntryLink;

  _metalSoy["default"].register(ConnectedFragmentEntryLink, _FragmentEntryLink["default"]);

  var _default = ConnectedFragmentEntryLink;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEntryLink.es.js.map
});
//# sourceMappingURL=FragmentEntryLink.es.js.map