Liferay.Loader.define("layout-content-page-editor-web$lodash-es@4.17.15/_arrayEvery", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /**
   * A specialized version of `_.every` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if all elements pass the predicate check,
   *  else `false`.
   */
  function arrayEvery(array, predicate) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (!predicate(array[index], index, array)) {
        return false;
      }
    }
    return true;
  }

  export default arrayEvery;
});
//# sourceMappingURL=_arrayEvery.js.map