/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

'use strict';

Liferay.Loader.define('layout-content-page-editor-web$fbjs@0.8.17/lib/getDocumentScrollElement', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var isWebkit = typeof navigator !== 'undefined' && navigator.userAgent.indexOf('AppleWebKit') > -1;

  /**
   * Gets the element with the document scroll properties such as `scrollLeft` and
   * `scrollHeight`. This may differ across different browsers.
   *
   * NOTE: The return value can be null if the DOM is not yet ready.
   *
   * @param {?DOMDocument} doc Defaults to current document.
   * @return {?DOMElement}
   */
  function getDocumentScrollElement(doc) {
    doc = doc || document;
    if (doc.scrollingElement) {
      return doc.scrollingElement;
    }
    return !isWebkit && doc.compatMode === 'CSS1Compat' ? doc.documentElement : doc.body;
  }

  module.exports = getDocumentScrollElement;
});
//# sourceMappingURL=getDocumentScrollElement.js.map