Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/utils/FragmentsEditorDialogUtils", ['module', 'exports', 'require', '../actions/actions.es', '../components/content/CreateContentDialog.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.openAssetBrowser = openAssetBrowser;
  exports.openCreateContentDialog = openCreateContentDialog;
  exports.openImageSelector = openImageSelector;
  exports.startListeningWidgetConfigurationChange = startListeningWidgetConfigurationChange;
  exports.stopListeningWidgetConfigurationChange = stopListeningWidgetConfigurationChange;

  var _actions = require("../actions/actions.es");

  var _CreateContentDialog = _interopRequireDefault(require("../components/content/CreateContentDialog.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @private
   * @review
   * @type {null|{detach: Function}}
   */
  var _widgetConfigurationChangeHandler = null;
  /**
   * Possible types that can be returned by the image selector
   */

  var DOWNLOAD_FILE_ENTRY_IMAGE_SELECTOR_RETURN_TYPE = 'com.liferay.item.selector.criteria.DownloadFileEntryItemSelectorReturnType';
  /**
   * @param {object} options
   * @param {function} options.callback
   * @param {string} options.assetBrowserURL
   * @param {string} options.eventName
   * @param {string} options.modalTitle
   * @param {function} [options.destroyedCallback=null]
   */

  function openAssetBrowser(_ref) {
    var assetBrowserURL = _ref.assetBrowserURL,
        callback = _ref.callback,
        _ref$destroyedCallbac = _ref.destroyedCallback,
        destroyedCallback = _ref$destroyedCallbac === void 0 ? null : _ref$destroyedCallbac,
        eventName = _ref.eventName,
        modalTitle = _ref.modalTitle;
    Liferay.Util.selectEntity({
      dialog: {
        constrain: true,
        destroyOnHide: true,
        modal: true
      },
      eventName: eventName,
      title: modalTitle,
      uri: assetBrowserURL
    }, function (event) {
      if (event.assetclassnameid) {
        callback({
          className: event.assetclassname,
          classNameId: event.assetclassnameid,
          classPK: event.assetclasspk,
          title: event.assettitle
        });
      } else if (destroyedCallback) {
        destroyedCallback();
      }
    });
  }
  /**
   * @param {object} store Store
   * @return {CreateContentDialog}
   */

  function openCreateContentDialog(store) {
    return new _CreateContentDialog["default"]({
      store: store
    });
  }
  /**
   * @param {object} options
   * @param {function} options.callback
   * @param {string} options.imageSelectorURL
   * @param {string} options.portletNamespace
   * @param {function} [options.destroyedCallback=null]
   */

  function openImageSelector(_ref2) {
    var callback = _ref2.callback,
        _ref2$destroyedCallba = _ref2.destroyedCallback,
        destroyedCallback = _ref2$destroyedCallba === void 0 ? null : _ref2$destroyedCallba,
        imageSelectorURL = _ref2.imageSelectorURL,
        portletNamespace = _ref2.portletNamespace;
    AUI().use('liferay-item-selector-dialog', function (A) {
      var itemSelector = new A.LiferayItemSelectorDialog({
        eventName: "".concat(portletNamespace, "selectImage"),
        on: {
          selectedItemChange: function selectedItemChange(event) {
            var selectedItem = event.newVal || {};
            var returnType = selectedItem.returnType,
                value = selectedItem.value;
            var selectedImage = {};

            if (returnType === 'URL') {
              selectedImage.title = value;
              selectedImage.url = value;
            }

            if (returnType === DOWNLOAD_FILE_ENTRY_IMAGE_SELECTOR_RETURN_TYPE) {
              var fileEntry = JSON.parse(value);
              selectedImage.title = fileEntry.title;
              selectedImage.url = fileEntry.url;
            }

            if (selectedImage.url) {
              callback(selectedImage);
            }
          },
          visibleChange: function visibleChange(event) {
            if (event.newVal === false && destroyedCallback) {
              destroyedCallback();
            }
          }
        },
        title: Liferay.Language.get('select'),
        url: imageSelectorURL
      });
      itemSelector.open();
    });
  }
  /**
   * @param {{dispatch: Function}} store
   * @review
   */

  function startListeningWidgetConfigurationChange(store) {
    stopListeningWidgetConfigurationChange();
    var submitFormHandler = null;
    _widgetConfigurationChangeHandler = Liferay.after('popupReady', function (event) {
      var configurationForm = event.win.document.querySelector('.portlet-configuration-setup');

      if (configurationForm) {
        if (submitFormHandler) {
          submitFormHandler.detach();
          submitFormHandler = null;
        }

        submitFormHandler = event.win.Liferay.on('submitForm', function () {
          store.dispatch({
            lastSaveDate: new Date(),
            type: _actions.UPDATE_LAST_SAVE_DATE
          });
        });
      }
    });
  }
  /**
   * @review
   */

  function stopListeningWidgetConfigurationChange() {
    if (_widgetConfigurationChangeHandler) {
      _widgetConfigurationChangeHandler.detach();

      _widgetConfigurationChangeHandler = null;
    }
  }
  //# sourceMappingURL=FragmentsEditorDialogUtils.js.map
});
//# sourceMappingURL=FragmentsEditorDialogUtils.js.map