Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/reducers/changes.es", ['module', 'exports', 'require', '../actions/actions.es', '../utils/FragmentsEditorUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.saveChangesReducer = saveChangesReducer;

  var _actions = require("../actions/actions.es");

  var _FragmentsEditorUpdateUtils = require("../utils/FragmentsEditorUpdateUtils.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * @param {!object} state
   * @param {object} action
   * @param {Date} action.lastSaveDate
   * @param {boolean} action.savingChanges
   * @param {string} action.type
   * @return {object}
   * @review
   */
  function saveChangesReducer(state, action) {
    var nextState = state;

    if (action.type === _actions.UPDATE_LAST_SAVE_DATE) {
      var newDate = action.lastSaveDate.toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['lastSaveDate'], newDate);
    } else if (action.type === _actions.UPDATE_SAVING_CHANGES_STATUS) {
      nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['savingChanges'], Boolean(action.savingChanges));
    }

    return nextState;
  }
  //# sourceMappingURL=changes.es.js.map
});
//# sourceMappingURL=changes.es.js.map