Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_processors/EditableTextFragmentProcessor.es", ['module', 'exports', 'require', '../../utils/constants', './EditableRichTextFragmentProcessor.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getFloatingToolbarButtons = getFloatingToolbarButtons;
  exports.render = render;
  exports["default"] = void 0;

  var _constants = require("../../utils/constants");

  var _EditableRichTextFragmentProcessor = require("./EditableRichTextFragmentProcessor.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */
  function getFloatingToolbarButtons(editableValues) {
    var buttons = [];

    var linkButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.link);

    if (editableValues.config && (editableValues.config.fieldId || editableValues.config.href || editableValues.config.mappedField)) {
      linkButton.cssClass = 'fragments-editor__floating-toolbar--linked-field';
    }

    buttons.push(linkButton);

    var editButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.edit);

    if (editableValues.mappedField || editableValues.fieldId) {
      editButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field disabled fragments-editor__floating-toolbar--disabled';
    }

    buttons.push(editButton);

    var mapButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.map);

    if (editableValues.fieldId || editableValues.mappedField) {
      mapButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field';
    }

    buttons.push(mapButton);
    return buttons;
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {string} value Translated/segmented value
   * @return {string} Transformed content
   */

  function render(content, value, editableValues) {
    if (editableValues && editableValues.config && editableValues.config.href) {
      var link = document.createElement('a');
      var config = editableValues.config;
      link.innerHTML = value;
      link.href = config.href;

      if (config.target) {
        link.target = config.target;
      }

      return link.outerHTML;
    }

    return value;
  }

  var _default = {
    destroy: _EditableRichTextFragmentProcessor.destroy,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: _EditableRichTextFragmentProcessor.init,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=EditableTextFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableTextFragmentProcessor.es.js.map