Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_processors/EditableImageFragmentProcessor.es", ['module', 'exports', 'require', '../../utils/FragmentsEditorDialogUtils', '../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _FragmentsEditorDialogUtils = require("../../utils/FragmentsEditorDialogUtils");

  var _constants = require("../../utils/constants");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Handle item selector image changes and propagate them with an
   * "editableChanged" event.
   * @param {object} image
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {function} changedCallback
   * @private
   */
  function _handleImageEditorChange(image, editableElement, fragmentEntryLinkId, changedCallback) {
    var imageElement = editableElement.querySelector('img');

    if (imageElement && image.url) {
      imageElement.src = image.url;
      changedCallback(image);
    }
  }
  /**
   * Do nothing, as LiferayItemSelectorDialog is automatically
   * destroyed on hide.
   * @review
   */

  function destroy() {}
  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */

  function getFloatingToolbarButtons(editableValues) {
    var buttons = [];

    var linkButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.link);

    if (editableValues.config && (editableValues.config.fieldId || editableValues.config.href || editableValues.config.mappedField)) {
      linkButton.cssClass = 'fragments-editor__floating-toolbar--linked-field';
    }

    buttons.push(linkButton);

    if (!editableValues.mappedField && !editableValues.fieldId) {
      buttons.push(_constants.FLOATING_TOOLBAR_BUTTONS.imageProperties);
    }

    var mapButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.map);

    if (editableValues.fieldId || editableValues.mappedField) {
      mapButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field';
    }

    buttons.push(mapButton);
    return buttons;
  }
  /**
   * Show the image selector dialog and calls the given callback when an
   * image is selected.
   * @param {HTMLElement} editableElement
   * @param {string} fragmentEntryLinkId
   * @param {string} portletNamespace
   * @param {{imageSelectorURL: string}} options
   * @param {function} changedCallback
   * @param {function} destroyedCallback
   * @review
   */

  function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback) {
    var imageSelectorURL = options.imageSelectorURL;
    (0, _FragmentsEditorDialogUtils.openImageSelector)({
      callback: function callback(image) {
        _handleImageEditorChange(image, editableElement, fragmentEntryLinkId, changedCallback);
      },
      destroyedCallback: destroyedCallback,
      imageSelectorURL: imageSelectorURL,
      portletNamespace: portletNamespace
    });
  }
  /**
   * @param {string} content editableField's original HTML
   * @param {object} value Translated/segmented value
   * @param {object} editableValues values of the element
   * @return {string} Transformed content
   */

  function render(content, value, editableValues) {
    var wrapper = document.createElement('div');
    var config = editableValues && editableValues.config || {};
    wrapper.innerHTML = content;
    var image = wrapper.querySelector('img');

    if (image) {
      var imageValue = value && typeof value !== 'string' ? value.url : value;

      if (imageValue) {
        image.src = imageValue;
      }

      if (config.alt) {
        image.alt = config.alt;
      }
    }

    if (editableValues && editableValues.config && editableValues.config.href) {
      var link = document.createElement('a');
      var _config = editableValues.config;
      link.href = _config.href;

      if (_config.target) {
        link.target = _config.target;
      }

      link.appendChild(image);
      return link.outerHTML;
    } else {
      return wrapper.innerHTML;
    }
  }

  var _default = {
    destroy: destroy,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: init,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=EditableImageFragmentProcessor.es.js.map
});
//# sourceMappingURL=EditableImageFragmentProcessor.es.js.map