Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_processors/EditableBackgroundImageProcessor.es", ['module', 'exports', 'require', '../../utils/FragmentsEditorDialogUtils', '../../utils/constants'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _FragmentsEditorDialogUtils = require("../../utils/FragmentsEditorDialogUtils");

  var _constants = require("../../utils/constants");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Do nothing, as LiferayItemSelectorDialog is automatically
   * destroyed on hide.
   * @review
   */
  function destroy() {}
  /**
   * @param {object} editableValues
   * @return {object[]} Floating toolbar panels
   */

  function getFloatingToolbarButtons(editableValues) {
    var buttons = [];

    var backgroundImageButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.fragmentBackgroundImage);

    var mapButton = _objectSpread({}, _constants.FLOATING_TOOLBAR_BUTTONS.map);

    if (editableValues.mappedField || editableValues.fieldId) {
      backgroundImageButton.cssClass = 'disabled fragments-editor__floating-toolbar--disabled fragments-editor__floating-toolbar--mapped-field';
      mapButton.cssClass = 'fragments-editor__floating-toolbar--mapped-field';
    }

    buttons.push(backgroundImageButton, mapButton);
    return buttons;
  }
  /**
   * Show the image selector dialog and calls the given callback when an
   * image is selected.
   * @param {function} callback
   * @param {string} imageSelectorURL
   * @param {string} portletNamespace
   * @review
   */

  function init(callback, imageSelectorURL, portletNamespace) {
    (0, _FragmentsEditorDialogUtils.openImageSelector)({
      callback: callback,
      imageSelectorURL: imageSelectorURL,
      portletNamespace: portletNamespace
    });
  }
  /**
   * @param {HTMLElement} element
   * @param {object} [backgroundImage={}]
   */

  function render(element) {
    var backgroundImage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    element.style.backgroundImage = backgroundImage ? "url(\"".concat(backgroundImage.url ? backgroundImage.url : backgroundImage, "\")") : '';
    element.style.backgroundSize = 'cover';
  }

  var _default = {
    destroy: destroy,
    getFloatingToolbarButtons: getFloatingToolbarButtons,
    init: init,
    render: render
  };
  exports["default"] = _default;
  //# sourceMappingURL=EditableBackgroundImageProcessor.es.js.map
});
//# sourceMappingURL=EditableBackgroundImageProcessor.es.js.map