Liferay.Loader.define("layout-content-page-editor-web@1.0.126/js/components/fragment_entry_link/FragmentEditableField.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../floating_toolbar/image_properties/FloatingToolbarImagePropertiesPanel.es', '../floating_toolbar/link/FloatingToolbarLinkPanel.es', '../floating_toolbar/mapping/FloatingToolbarMappingPanel.es', './FragmentEditableFieldTooltip.es', '../../actions/actions.es', '../../actions/saveChanges.es', '../../actions/updateEditableValue.es', '../../store/ConnectedComponent.es', '../../utils/FragmentsEditorComponentUtils.es', '../../utils/FragmentsEditorGetUtils.es', '../../utils/FragmentsEditorUpdateUtils.es', '../../utils/constants', '../../utils/debouncedAlert.es', '../../utils/prefixSegmentsExperienceId.es', '../floating_toolbar/FloatingToolbar.es', '../fragment_processors/FragmentProcessors.es', './FragmentEditableField.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FragmentEditableField = exports.ConnectedFragmentEditableField = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("../floating_toolbar/image_properties/FloatingToolbarImagePropertiesPanel.es");

  require("../floating_toolbar/link/FloatingToolbarLinkPanel.es");

  require("../floating_toolbar/mapping/FloatingToolbarMappingPanel.es");

  require("./FragmentEditableFieldTooltip.es");

  var _actions = require("../../actions/actions.es");

  var _saveChanges = require("../../actions/saveChanges.es");

  var _updateEditableValue = require("../../actions/updateEditableValue.es");

  var _ConnectedComponent = require("../../store/ConnectedComponent.es");

  var _FragmentsEditorComponentUtils = require("../../utils/FragmentsEditorComponentUtils.es");

  var _FragmentsEditorGetUtils = require("../../utils/FragmentsEditorGetUtils.es");

  var _FragmentsEditorUpdateUtils = require("../../utils/FragmentsEditorUpdateUtils.es");

  var _constants = require("../../utils/constants");

  var _debouncedAlert = _interopRequireDefault(require("../../utils/debouncedAlert.es"));

  var _prefixSegmentsExperienceId = require("../../utils/prefixSegmentsExperienceId.es");

  var _FloatingToolbar = _interopRequireDefault(require("../floating_toolbar/FloatingToolbar.es"));

  var _FragmentProcessors = _interopRequireDefault(require("../fragment_processors/FragmentProcessors.es"));

  var _FragmentEditableField = _interopRequireDefault(require("./FragmentEditableField.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @type {number}
   * @review
   */
  var EDITABLE_FIELD_CHANGE_DELAY = 500;
  /**
   * FragmentEditableField
   */

  var FragmentEditableField = /*#__PURE__*/function (_PortletBase) {
    _inherits(FragmentEditableField, _PortletBase);

    function FragmentEditableField() {
      _classCallCheck(this, FragmentEditableField);

      return _possibleConstructorReturn(this, _getPrototypeOf(FragmentEditableField).apply(this, arguments));
    }

    _createClass(FragmentEditableField, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        this._clearEditor = this._clearEditor.bind(this);
        this._createProcessor = this._createProcessor.bind(this);
        this._handleEditableChanged = this._handleEditableChanged.bind(this);
        this._handleProcessorDestroyed = this._handleProcessorDestroyed.bind(this);
        this._handleFloatingToolbarButtonClicked = this._handleFloatingToolbarButtonClicked.bind(this);

        if (['link', 'rich-text', 'text'].includes(this.type)) {
          this._handleEditableChanged = (0, _debouncedAlert["default"])(this._handleEditableChanged.bind(this), EDITABLE_FIELD_CHANGE_DELAY);
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._destroyProcessors();

        this._disposeFloatingToolbar();

        this.element.removeEventListener('click', this._createProcessor);
      }
      /**
       * @inheritDoc
       * @param {!object} state
       * @returns {object}
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var activable = this._editableIsActivable();

        var defaultSegmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.defaultSegmentsExperienceId);
        var segmentsExperienceId = (0, _prefixSegmentsExperienceId.prefixSegmentsExperienceId)(this.segmentsExperienceId);
        var segmentedValue = this.editableValues[segmentsExperienceId] || this.editableValues[defaultSegmentsExperienceId] || this.editableValues;
        var segmentDefaultValue = this.editableValues;
        var translatedValue = segmentedValue[this.languageId] || segmentDefaultValue[this.languageId] || segmentedValue[this.defaultLanguageId];
        var mapped = (0, _FragmentsEditorGetUtils.editableIsMapped)(this.editableValues);
        var value = mapped ? this._mappedFieldValue || this.editableValues.defaultValue : translatedValue || this.editableValues.defaultValue;
        this._initialValue = value;
        var processor = _FragmentProcessors["default"][this.type] || _FragmentProcessors["default"].fallback;

        var content = _metalSoy["default"].toIncDom(processor.render(this.content, value, this.editableValues));

        var highlighted = (0, _FragmentsEditorGetUtils.editableShouldBeHighlighted)(state.activeItemId, state.activeItemType, state.fragmentEntryLinkId, state.layoutData.structure);

        var itemId = this._getItemId();

        var translated = !mapped && Boolean(segmentedValue[this.languageId]);
        var nextState = state;
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_activable'], activable);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_highlighted'], highlighted);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_mapped'], mapped);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_selected'], state.selectedItems.some(function (selectedItem) {
          return selectedItem.itemId === itemId && selectedItem.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable;
        }));
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['_translated'], translated);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['content'], content);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['itemId'], itemId);
        nextState = (0, _FragmentsEditorUpdateUtils.setIn)(nextState, ['itemTypes'], _constants.FRAGMENTS_EDITOR_ITEM_TYPES);
        return nextState;
      }
      /**
       * @inheritDoc
       * @return {boolean}
       * @review
       */

    }, {
      key: "shouldUpdate",
      value: function shouldUpdate(changes) {
        if (this._processorEnabled) {
          return (0, _FragmentsEditorComponentUtils.shouldUpdateOnChangeProperties)(changes, ['activeItemId', 'activeItemType', 'languageId', 'segmentsExperienceId']);
        }

        return (0, _FragmentsEditorComponentUtils.shouldUpdatePureComponent)(changes);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncActiveItemId",
      value: function syncActiveItemId() {
        var eventName = this.type === 'image' ? 'dblclick' : 'click';

        if (this._getItemId() === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
          this._createFloatingToolbar();

          this.element.addEventListener(eventName, this._createProcessor);
        } else {
          this._disposeFloatingToolbar();

          this._destroyProcessors();

          this.element.removeEventListener(eventName, this._createProcessor);
        }
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncEditableValues",
      value: function syncEditableValues() {
        this._loadMappedFieldLabel();

        this._updateMappedFieldValue();

        if (!this._processorEnabled && this._getItemId() === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
          this._createFloatingToolbar();
        }
      }
      /**
       * Handle getAssetFieldValueURL changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncGetAssetFieldValueURL",
      value: function syncGetAssetFieldValueURL() {
        this._updateMappedFieldValue();
      }
      /**
       * Handle hoveredItemId changed
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncHoveredItemId",
      value: function syncHoveredItemId() {
        if (this.hoveredItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.mappedItem) {
          var _this$hoveredItemId$s = this.hoveredItemId.split('-'),
              _this$hoveredItemId$s2 = _slicedToArray(_this$hoveredItemId$s, 2),
              classNameId = _this$hoveredItemId$s2[0],
              classPK = _this$hoveredItemId$s2[1];

          this._mappedItemHovered = this.editableValues.classNameId === classNameId && this.editableValues.classPK === classPK;
        } else {
          this._mappedItemHovered = false;
        }
      }
      /**
       * Clears the corresponding editor
       * @private
       * @review
       */

    }, {
      key: "_clearEditor",
      value: function _clearEditor() {
        this._handleEditableChanged('');
      }
      /**
       * Creates a new instance of FloatingToolbar
       * @private
       * @review
       */

    }, {
      key: "_createFloatingToolbar",
      value: function _createFloatingToolbar() {
        var processor = _FragmentProcessors["default"][this.type] || _FragmentProcessors["default"].fallback;
        var buttons = processor.getFloatingToolbarButtons(this.editableValues);

        if (this.selectedItems.length > 1) {
          buttons = buttons.map(function (button) {
            if (button.id === _constants.FLOATING_TOOLBAR_BUTTONS.map.id) {
              return button;
            }

            return _objectSpread({}, button, {
              cssClass: "".concat(button.cssClass, " disabled fragments-editor__floating-toolbar--disabled")
            });
          });
        }

        var config = {
          anchorElement: this.element,
          buttons: buttons,
          events: {
            buttonClicked: this._handleFloatingToolbarButtonClicked,
            clearEditor: this._clearEditor,
            createProcessor: this._createProcessor
          },
          item: {
            editableId: this.editableId,
            editableValues: this.editableValues,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            type: this.type
          },
          itemId: this._getItemId(),
          itemType: _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable,
          portalElement: document.body,
          store: this.store
        };

        if (this._floatingToolbar) {
          this._floatingToolbar.setState(config);
        } else {
          this._floatingToolbar = new _FloatingToolbar["default"](config);
        }
      }
      /**
       * Call destroy method on all processors
       * @private
       * @review
       */

    }, {
      key: "_destroyProcessors",
      value: function _destroyProcessors() {
        Object.values(_FragmentProcessors["default"]).forEach(function (fragmentProcessor) {
          return fragmentProcessor.destroy();
        });
      }
      /**
       * Disposes an existing instance of FloatingToolbar
       * @private
       * @review
       */

    }, {
      key: "_disposeFloatingToolbar",
      value: function _disposeFloatingToolbar() {
        var _this = this;

        if (this._floatingToolbar) {
          requestAnimationFrame(function () {
            _this._floatingToolbar.dispose();

            _this._floatingToolbar = null;
          });
        }
      }
      /**
       * Checks whether an editable is activable or not
       * @private
       * @review
       */

    }, {
      key: "_editableIsActivable",
      value: function _editableIsActivable() {
        var _this2 = this;

        var fragmentEntryLinkIsActive = this.fragmentEntryLinkId === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
        var siblingIsActive = (0, _FragmentsEditorGetUtils.getItemPath)(this.activeItemId, this.activeItemType, this.layoutData.structure).some(function (item) {
          return item.itemId === _this2.fragmentEntryLinkId && item.itemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.fragment;
        });
        return fragmentEntryLinkIsActive || siblingIsActive;
      }
      /**
       * Enables the corresponding processor
       * @private
       * @review
       */

    }, {
      key: "_createProcessor",
      value: function _createProcessor(event) {
        var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _constants.CREATE_PROCESSOR_EVENT_TYPES.editable;

        if (event) {
          event.preventDefault();
        }

        if (!this._processorEnabled && !this.editableValues.fieldId && !this.editableValues.mappedField) {
          this._processorEnabled = true;

          this._disposeFloatingToolbar();

          var _ref = _FragmentProcessors["default"][this.type] || _FragmentProcessors["default"].fallback,
              init = _ref.init;

          init(this.refs.editable, this.fragmentEntryLinkId, this.portletNamespace, this.processorsOptions, this._handleEditableChanged, this._handleProcessorDestroyed, event, type, this._initialValue);
        }
      }
      /**
       * @private
       * @return {string} Valid FragmentsEditor itemId for it's
       * 	fragmentEntryLinkId and editableId
       * @review
       */

    }, {
      key: "_getItemId",
      value: function _getItemId() {
        return "".concat(this.fragmentEntryLinkId, "-").concat(this.editableId);
      }
      /**
       * Callback executed when the exiting processor is destroyed
       * @private
       * @review
       */

    }, {
      key: "_handleProcessorDestroyed",
      value: function _handleProcessorDestroyed() {
        this._processorEnabled = false;

        if (this._getItemId() === this.activeItemId && this.activeItemType === _constants.FRAGMENTS_EDITOR_ITEM_TYPES.editable) {
          this._createFloatingToolbar();
        }
      }
      /**
       * Callback executed when an editable value changes
       * @param {string} newValue
       * @private
       */

    }, {
      key: "_handleEditableChanged",
      value: function _handleEditableChanged(newValue) {
        if (this.type === 'image') {
          var _config;

          this.store.dispatch((0, _saveChanges.enableSavingChangesStatusAction)()).dispatch({
            config: (_config = {}, _defineProperty(_config, _constants.EDITABLE_FIELD_CONFIG_KEYS.imageSource, newValue.url), _defineProperty(_config, _constants.EDITABLE_FIELD_CONFIG_KEYS.imageTitle, newValue.title), _config),
            editableId: this.editableId,
            fragmentEntryLinkId: this.fragmentEntryLinkId,
            type: _actions.UPDATE_CONFIG_ATTRIBUTES
          }).dispatch((0, _saveChanges.updateLastSaveDateAction)()).dispatch((0, _saveChanges.disableSavingChangesStatusAction)());
        }

        this.store.dispatch((0, _updateEditableValue.updateEditableValueContentAction)(this.fragmentEntryLinkId, _constants.EDITABLE_FRAGMENT_ENTRY_PROCESSOR, this.editableId, newValue));
      }
      /**
       * Callback executed when an floating toolbar button is clicked
       * @param {Event} event
       * @param {Object} data
       * @private
       */

    }, {
      key: "_handleFloatingToolbarButtonClicked",
      value: function _handleFloatingToolbarButtonClicked(event, data) {
        var type = data.type;

        if (type === 'editor') {
          this._createProcessor(event, _constants.CREATE_PROCESSOR_EVENT_TYPES.button);
        }
      }
      /**
       * Load mapped field label
       * @private
       * @review
       */

    }, {
      key: "_loadMappedFieldLabel",
      value: function _loadMappedFieldLabel() {
        var _this3 = this;

        var promise;
        var mappedFieldId;

        if (this.editableValues.mappedField && this.selectedMappingTypes.type) {
          var data = {
            classNameId: this.selectedMappingTypes.type.id
          };

          if (this.selectedMappingTypes.subtype) {
            data.classTypeId = this.selectedMappingTypes.subtype.id;
          }

          mappedFieldId = this.editableValues.mappedField;
          promise = this.fetch(this.mappingFieldsURL, data);
        } else if (this.editableValues.classNameId && this.editableValues.classPK && this.editableValues.fieldId && this.getAssetMappingFieldsURL) {
          mappedFieldId = this.editableValues.fieldId;
          promise = this.fetch(this.getAssetMappingFieldsURL, {
            classNameId: this.editableValues.classNameId,
            classPK: this.editableValues.classPK
          });
        }

        if (promise) {
          promise.then(function (response) {
            return response.json();
          }).then(function (response) {
            var field = response.find(function (field) {
              return field.key === mappedFieldId;
            });

            if (field) {
              _this3._mappedFieldLabel = field.label;
            }
          });
        }
      }
      /**
       * Updates mapped field value
       * @private
       * @review
       */

    }, {
      key: "_updateMappedFieldValue",
      value: function _updateMappedFieldValue() {
        var _this4 = this;

        if (this.getAssetFieldValueURL && (0, _FragmentsEditorGetUtils.editableIsMappedToAssetEntry)(this.editableValues)) {
          this.fetch(this.getAssetFieldValueURL, {
            classNameId: this.editableValues.classNameId,
            classPK: this.editableValues.classPK,
            fieldId: this.editableValues.fieldId
          }).then(function (response) {
            return response.json();
          }).then(function (response) {
            var fieldValue = response.fieldValue;

            if (fieldValue) {
              if (_this4.type === 'image' && typeof fieldValue.url === 'string') {
                _this4._mappedFieldValue = fieldValue.url;
              } else {
                _this4._mappedFieldValue = fieldValue;
              }
            }
          });
        }
      }
    }]);

    return FragmentEditableField;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.FragmentEditableField = FragmentEditableField;
  FragmentEditableField.STATE = {
    /**
     * Internal FloatingToolbar instance.
     * @default null
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {object|null}
     */
    _floatingToolbar: _metalState.Config.internal().value(null),

    /**
     * Initial value before render
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {any}
     */
    _initialValue: _metalState.Config.any(),

    /**
     * Translated label of the mapped field
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldLabel: _metalState.Config.internal().string(),

    /**
     * Mapped asset field value
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {string}
     */
    _mappedFieldValue: _metalState.Config.internal().string(),

    /**
     * Mapped content hovered
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _mappedItemHovered: _metalState.Config.internal().bool().value(false),

    /**
     * @instance
     * @memberOf FragmentEditableField
     * @private
     * @review
     * @type {boolean}
     */
    _processorEnabled: _metalState.Config.internal().bool().value(false),

    /**
     * Editable content to be rendered
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    content: _metalState.Config.string().required(),

    /**
     * Editable ID
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    editableId: _metalState.Config.string().required(),

    /**
     * Editable values
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    editableValues: _metalState.Config.object().required(),

    /**
     * FragmentEntryLink id
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    fragmentEntryLinkId: _metalState.Config.string().required(),

    /**
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    processor: _metalState.Config.string().required(),

    /**
     * Set of options that are sent to the processors.
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!object}
     */
    processorsOptions: _metalState.Config.object().required(),

    /**
     * Editable type
     * @default undefined
     * @instance
     * @memberOf FragmentEditableField
     * @review
     * @type {!string}
     */
    type: _metalState.Config.oneOf(['html', 'image', 'link', 'rich-text', 'text']).required()
  };
  var ConnectedFragmentEditableField = (0, _ConnectedComponent.getConnectedComponent)(FragmentEditableField, ['activeItemId', 'activeItemType', 'defaultLanguageId', 'defaultSegmentsExperienceId', 'getAssetFieldValueURL', 'getAssetMappingFieldsURL', 'hoveredItemId', 'hoveredItemType', 'languageId', 'layoutData', 'mappingFieldsURL', 'portletNamespace', 'segmentsExperienceId', 'selectedMappingTypes', 'selectedItems']);
  exports.ConnectedFragmentEditableField = ConnectedFragmentEditableField;

  _metalSoy["default"].register(ConnectedFragmentEditableField, _FragmentEditableField["default"]);

  var _default = ConnectedFragmentEditableField;
  exports["default"] = _default;
  //# sourceMappingURL=FragmentEditableField.es.js.map
});
//# sourceMappingURL=FragmentEditableField.es.js.map