/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.change.tracking.internal.service;

import com.liferay.change.tracking.engine.CTManager;
import com.liferay.change.tracking.engine.exception.CTEngineException;
import com.liferay.change.tracking.engine.exception.CTEntryCTEngineException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutVersion;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutLocalServiceWrapper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class CTLayoutLocalServiceWrapper
extends LayoutLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(CTLayoutLocalServiceWrapper.class);
    @Reference
    private CTManager _ctManager;
    @Reference
    private LayoutLocalServiceHelper _layoutLocalServiceHelper;
    @Reference
    private Portal _portal;

    public CTLayoutLocalServiceWrapper() {
        super(null);
    }

    public CTLayoutLocalServiceWrapper(LayoutLocalService layoutLocalService) {
        super(layoutLocalService);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, long classNameId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        Layout layout = (Layout)this._ctManager.executeModelUpdate(() -> super.addLayout(userId, groupId, privateLayout, parentLayoutId, classNameId, classPK, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, serviceContext));
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 0);
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        Layout layout = (Layout)this._ctManager.executeModelUpdate(() -> super.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, system, friendlyURLMap, serviceContext));
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 0);
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        Layout layout = (Layout)this._ctManager.executeModelUpdate(() -> super.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, friendlyURLMap, serviceContext));
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 0);
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, boolean system, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Layout layout = (Layout)this._ctManager.executeModelUpdate(() -> super.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, system, friendlyURL, serviceContext));
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 0);
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Layout layout = (Layout)this._ctManager.executeModelUpdate(() -> super.addLayout(userId, groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext));
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 0);
        return layout;
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        Layout layout = super.updateIconImage(plid, bytes);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateLayout(Layout layout) throws PortalException {
        Layout updatedLayout = super.updateLayout(layout);
        LayoutVersion layoutVersion = this.fetchLatestVersion(updatedLayout);
        this._registerChange(layoutVersion, 2);
        return updatedLayout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, Date publishDate) throws PortalException {
        Layout layout = super.updateLayout(groupId, privateLayout, layoutId, publishDate);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long classNameId, long classPK) throws PortalException {
        Layout layout = super.updateLayout(groupId, privateLayout, layoutId, classNameId, classPK);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        Layout layout = super.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Layout layout = super.updateLayout(groupId, privateLayout, layoutId, typeSettings);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        Layout layout = super.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException {
        Layout updatedLayout = super.updateName(layout, name, languageId);
        LayoutVersion layoutVersion = this.fetchLatestVersion(updatedLayout);
        this._registerChange(layoutVersion, 2);
        return updatedLayout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        Layout layout = super.updateName(groupId, privateLayout, layoutId, name, languageId);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        Layout layout = super.updateName(plid, name, languageId);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException {
        super.updatePriorities(groupId, privateLayout);
        List layouts = this.getLayouts(groupId, privateLayout);
        for (Layout layout : layouts) {
            LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
            this._registerChange(layoutVersion, 2);
        }
    }

    public Layout updatePriority(Layout layout, int priority) throws PortalException {
        int nextPriority;
        Layout updatedLayout = super.updatePriority(layout, priority);
        if (layout.getPriority() == priority) {
            return updatedLayout;
        }
        int oldPriority = layout.getPriority();
        if (oldPriority == (nextPriority = this._layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority))) {
            return updatedLayout;
        }
        LayoutVersion layoutVersion = this.fetchLatestVersion(updatedLayout);
        this._registerChange(layoutVersion, 2);
        List layouts = super.getLayouts(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        boolean lessThan = false;
        if (oldPriority < nextPriority) {
            lessThan = true;
        }
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        int newPriority = 0;
        for (Layout curLayout : layouts) {
            int curNextPriority = this._layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), newPriority++);
            if (curLayout.getPriority() == curNextPriority) continue;
            LayoutVersion curlayoutVersion = this.fetchLatestVersion(curLayout);
            this._registerChange(curlayoutVersion, 2);
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return updatedLayout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        Layout layout = super.updatePriority(groupId, privateLayout, layoutId, priority);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        Layout layout = super.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        Layout layout = super.updatePriority(plid, priority);
        LayoutVersion layoutVersion = this.fetchLatestVersion(layout);
        this._registerChange(layoutVersion, 2);
        return layout;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
    }

    private void _registerChange(LayoutVersion layoutVersion, int changeType) throws CTEngineException {
        if (layoutVersion == null) {
            return;
        }
        try {
            this._ctManager.registerModelChange(layoutVersion.getCompanyId(), PrincipalThreadLocal.getUserId(), this._portal.getClassNameId(LayoutVersion.class.getName()), layoutVersion.getLayoutVersionId(), layoutVersion.getPlid(), changeType);
        }
        catch (CTEngineException ctee) {
            if (ctee instanceof CTEntryCTEngineException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)ctee.getMessage());
                }
            }
            throw ctee;
        }
    }
}

