/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.apio.internal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class LayoutResourceCollectionUtil {
    private static final Log _log = LogFactoryUtil.getLog(LayoutResourceCollectionUtil.class);

    public static String getBreadcrumb(Layout layout, Locale locale) {
        List ancestorLayouts = null;
        try {
            ancestorLayouts = layout.getAncestors();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get layout ancestors", (Throwable)e);
            return "";
        }
        StringBundler sb = new StringBundler(4 * ancestorLayouts.size() + 5);
        if (layout.isPrivateLayout()) {
            sb.append(LanguageUtil.get((Locale)locale, (String)"private-pages"));
        } else {
            sb.append(LanguageUtil.get((Locale)locale, (String)"public-pages"));
        }
        sb.append(" ");
        sb.append(">");
        sb.append(" ");
        Collections.reverse(ancestorLayouts);
        for (Layout ancestorLayout : ancestorLayouts) {
            sb.append(HtmlUtil.escape((String)ancestorLayout.getName(locale)));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        sb.append(HtmlUtil.escape((String)layout.getName(locale)));
        return sb.toString();
    }

    public static String getImageURL(Layout layout) {
        ServiceContext serviceContext = Optional.ofNullable(ServiceContextThreadLocal.getServiceContext()).orElse(new ServiceContext());
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (layout == null || themeDisplay == null || !layout.isIconImage()) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(themeDisplay.getPathImage());
        sb.append("/layout_icon?img_id");
        sb.append(layout.getIconImageId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)layout.getIconImageId()));
        return sb.toString();
    }
}

