/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.layout.apio.architect.identifier.EmbeddedWebPageIdentifier;
import com.liferay.layout.apio.internal.util.LayoutResourceCollectionUtil;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.site.apio.architect.identifier.WebSiteIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionResource.class})
public class EmbeddedWebPageNestedCollectionResource
implements NestedCollectionResource<Layout, Long, EmbeddedWebPageIdentifier, Long, WebSiteIdentifier> {
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Layout)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;

    public NestedCollectionRoutes<Layout, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<Layout, Long, Long> builder) {
        return builder.addGetter(this::_getLayouts).build();
    }

    public String getName() {
        return "embedded-web-page";
    }

    public ItemRoutes<Layout, Long> itemRoutes(ItemRoutes.Builder<Layout, Long> builder) {
        return builder.addGetter(arg_0 -> ((LayoutLocalService)this._layoutLocalService).getLayout(arg_0)).addRemover(Idempotent.idempotent(arg_0 -> ((LayoutLocalService)this._layoutLocalService).deleteLayout(arg_0)), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).build();
    }

    public Representor<Layout> representor(Representor.Builder<Layout, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("EmbeddedWebPage", new String[0]).identifier(LayoutModel::getPlid).addBidirectionalModel("webSite", "embeddedWebPages", WebSiteIdentifier.class, LayoutModel::getGroupId).addDate("dateCreated", LayoutModel::getCreateDate)).addDate("dateModified", LayoutModel::getModifiedDate)).addLocalizedStringByLocale("breadcrumb", LayoutResourceCollectionUtil::getBreadcrumb)).addLocalizedStringByLocale("description", LayoutModel::getDescription)).addLocalizedStringByLocale("keywords", LayoutModel::getKeywords)).addLocalizedStringByLocale("name", LayoutModel::getName)).addLocalizedStringByLocale("title", LayoutModel::getTitle)).addLocalizedStringByLocale("url", Layout::getFriendlyURL)).addString("embeddedUrl", layout -> layout.getTypeSettingsProperty("embeddedLayoutURL"))).addString("image", LayoutResourceCollectionUtil::getImageURL)).addStringList("availableLanguages", layout -> Arrays.asList(LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds())))).build();
    }

    private PageItems<Layout> _getLayouts(Pagination pagination, long groupId) {
        List layouts = this._layoutService.getLayouts(groupId, "embedded", pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._layoutService.getLayoutsCount(groupId, "embedded");
        return new PageItems((Collection)layouts, count);
    }
}

