/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import java.util.Objects;

public class ContainerStyledLayoutStructureItem
extends StyledLayoutStructureItem {
    private static final Map<String, String> _borderRadius = HashMapBuilder.put((Object)"rounded", (Object)"0.25rem").put((Object)"rounded-circle", (Object)"50%").put((Object)"rounded-lg", (Object)"0.375rem").put((Object)"rounded-pill", (Object)"50rem").put((Object)"rounded-sm", (Object)"50rem").build();
    private static final Map<String, String> _colors = HashMapBuilder.put((Object)"danger", (Object)"#DA1414").put((Object)"dark", (Object)"#272833").put((Object)"gray-dark", (Object)"#393A4A").put((Object)"info", (Object)"#2E5AAC").put((Object)"light", (Object)"#F1F2F5").put((Object)"lighter", (Object)"#F7F8F9").put((Object)"primary", (Object)"#0B5FFF").put((Object)"secondary", (Object)"#6B6C7E").put((Object)"success", (Object)"#287D3C").put((Object)"warning", (Object)"#B95000").put((Object)"white", (Object)"#FFFFFF").build();
    private static final Map<String, String> _shadows = HashMapBuilder.put((Object)"shadow", (Object)"0 .5rem 1rem rgba(0, 0, 0, 0.15)").put((Object)"shadow-lg", (Object)"0 1rem 3rem rgba(0, 0, 0, 0.175)").put((Object)"shadow-none", (Object)"none").put((Object)"shadow-sm", (Object)"0 .125rem .25rem rgba(0, 0, 0, 0.075)").build();
    private JSONObject _linkJSONObject = JSONFactoryUtil.createJSONObject();
    private String _widthType = "fluid";

    public ContainerStyledLayoutStructureItem(String parentItemId) {
        super(parentItemId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContainerStyledLayoutStructureItem)) {
            return false;
        }
        ContainerStyledLayoutStructureItem containerStyledLayoutStructureItem = (ContainerStyledLayoutStructureItem)object;
        if (!Objects.equals(this._linkJSONObject.toJSONString(), containerStyledLayoutStructureItem._linkJSONObject.toJSONString()) || !Objects.equals(this._widthType, containerStyledLayoutStructureItem._widthType)) {
            return false;
        }
        return super.equals(object);
    }

    @Deprecated
    public String getContainerType() {
        return this._widthType;
    }

    @Override
    public JSONObject getItemConfigJSONObject() {
        JSONObject jsonObject = super.getItemConfigJSONObject();
        return jsonObject.put("link", this._linkJSONObject).put("widthType", this._widthType);
    }

    @Override
    public String getItemType() {
        return "container";
    }

    public JSONObject getLinkJSONObject() {
        return this._linkJSONObject;
    }

    @Deprecated
    public int getPaddingHorizontal() {
        return 0;
    }

    public String getWidthType() {
        return this._widthType;
    }

    @Override
    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    @Deprecated
    public void setAlign(String align) {
    }

    @Deprecated
    public void setBackgroundColorCssClass(String backgroundColorCssClass) {
    }

    @Deprecated
    public void setBackgroundImageJSONObject(JSONObject backgroundImageJSONObject) {
    }

    @Deprecated
    public void setBorderColor(String borderColor) {
    }

    @Deprecated
    public void setBorderRadius(String borderRadius) {
    }

    @Deprecated
    public void setBorderWidth(int borderWidth) {
    }

    @Deprecated
    public void setContainerType(String containerType) {
        this._widthType = containerType;
    }

    @Deprecated
    public void setContentDisplay(String contentDisplay) {
    }

    @Deprecated
    public void setJustify(String justify) {
    }

    public void setLinkJSONObject(JSONObject linkJSONObject) {
        this._linkJSONObject = linkJSONObject;
    }

    @Deprecated
    public void setMarginBottom(int marginBottom) {
    }

    @Deprecated
    public void setMarginLeft(int marginLeft) {
    }

    @Deprecated
    public void setMarginRight(int marginRight) {
    }

    @Deprecated
    public void setMarginTop(int marginTop) {
    }

    @Deprecated
    public void setOpacity(int opacity) {
    }

    @Deprecated
    public void setPaddingBottom(int paddingBottom) {
    }

    @Deprecated
    public void setPaddingHorizontal(int paddingHorizontal) {
    }

    @Deprecated
    public void setPaddingLeft(int paddingLeft) {
    }

    @Deprecated
    public void setPaddingRight(int paddingRight) {
    }

    @Deprecated
    public void setPaddingTop(int paddingTop) {
    }

    @Deprecated
    public void setShadow(String shadow) {
    }

    public void setWidthType(String widthType) {
        this._widthType = widthType;
    }

    @Override
    public void updateItemConfig(JSONObject itemConfigJSONObject) {
        this._convertStyleProperties(itemConfigJSONObject);
        super.updateItemConfig(itemConfigJSONObject);
        if (itemConfigJSONObject.has("link")) {
            this.setLinkJSONObject(itemConfigJSONObject.getJSONObject("link"));
        }
        if (itemConfigJSONObject.has("containerType") || itemConfigJSONObject.has("type") || itemConfigJSONObject.has("widthType")) {
            if (itemConfigJSONObject.has("containerType")) {
                this.setWidthType(itemConfigJSONObject.getString("containerType"));
            } else if (itemConfigJSONObject.has("type")) {
                this.setWidthType(itemConfigJSONObject.getString("type"));
            } else {
                this.setWidthType(itemConfigJSONObject.getString("widthType"));
            }
        }
    }

    private void _convertStyleProperties(JSONObject itemConfigJSONObject) {
        String shadow;
        String borderRadius;
        String borderColor;
        String backgroundColorCssClass = itemConfigJSONObject.getString("backgroundColorCssClass");
        if (Validator.isNotNull((String)backgroundColorCssClass)) {
            itemConfigJSONObject.put("backgroundColor", _colors.getOrDefault(backgroundColorCssClass, backgroundColorCssClass));
        }
        if (Validator.isNotNull((String)(borderColor = itemConfigJSONObject.getString("borderColor")))) {
            itemConfigJSONObject.put("borderColor", _colors.getOrDefault(borderColor, borderColor));
        }
        if (Validator.isNotNull((String)(borderRadius = itemConfigJSONObject.getString("borderRadius")))) {
            itemConfigJSONObject.put("borderRadius", _borderRadius.getOrDefault(borderRadius, borderRadius));
        }
        if (Validator.isNotNull((String)(shadow = itemConfigJSONObject.getString("shadow")))) {
            itemConfigJSONObject.put("shadow", _shadows.getOrDefault(shadow, shadow));
        }
    }
}

