/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.template;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.layout.util.template.LayoutTypeSettingsInspectorUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.List;

public class LayoutColumn {
    private final List<Long> _fragmentEntryLinkIds = new ArrayList<Long>();
    private final Layout _layout;
    private int _size = 12;

    public static LayoutColumn of(Layout layout, UnsafeConsumer<LayoutColumn, Exception> unsafeConsumer) {
        LayoutColumn layoutColumn = new LayoutColumn(layout);
        try {
            unsafeConsumer.accept((Object)layoutColumn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return layoutColumn;
    }

    public void addPortlets(String columnId) throws PortalException {
        List<String> portletIds = LayoutTypeSettingsInspectorUtil.getPortletIds(this._layout.getTypeSettingsProperties(), columnId);
        for (String portletId : portletIds) {
            this._addPortlet(portletId);
        }
    }

    public List<Long> getFragmentEntryLinkIds() {
        return this._fragmentEntryLinkIds;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    private LayoutColumn(Layout layout) {
        this._layout = layout;
    }

    private void _addPortlet(String portletId) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.addFragmentEntryLink((long)serviceContext.getUserId(), (long)serviceContext.getScopeGroupId(), (long)0L, (long)0L, (long)PortalUtil.getClassNameId(Layout.class), (long)this._layout.getPlid(), (String)"", (String)"", (String)"", (String)"", (String)JSONUtil.put((String)"instanceId", (Object)PortletIdCodec.decodeInstanceId((String)portletId)).put("portletId", PortletIdCodec.decodePortletName((String)portletId)).toString(), (String)"", (int)0, null, (ServiceContext)serviceContext);
        this._fragmentEntryLinkIds.add(fragmentEntryLink.getFragmentEntryLinkId());
    }
}

