/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DeletedLayoutStructureItem {
    private final Set<String> _childrenItemIds;
    private final String _itemId;
    private final List<String> _portletIds;
    private final int _position;

    public static DeletedLayoutStructureItem of(JSONObject jsonObject) {
        if (jsonObject == null) {
            return new DeletedLayoutStructureItem("", Collections.emptyList());
        }
        return new DeletedLayoutStructureItem(jsonObject.getString("itemId"), JSONUtil.toStringList((JSONArray)jsonObject.getJSONArray("portletIds")), jsonObject.getInt("position"), JSONUtil.toStringSet((JSONArray)jsonObject.getJSONArray("childrenItemIds")));
    }

    public DeletedLayoutStructureItem(String itemId, List<String> portletIds) {
        this(itemId, portletIds, 0, Collections.emptySet());
    }

    public DeletedLayoutStructureItem(String itemId, List<String> portletIds, int position) {
        this(itemId, portletIds, position, Collections.emptySet());
    }

    public DeletedLayoutStructureItem(String itemId, List<String> portletIds, int position, Set<String> childrenItemIds) {
        this._itemId = itemId;
        this._portletIds = portletIds;
        this._position = position;
        this._childrenItemIds = childrenItemIds;
    }

    public boolean contains(String portletId) {
        return this._portletIds.contains(portletId);
    }

    public boolean containsItemId(String itemId) {
        return Objects.equals(itemId, this._itemId) || this._childrenItemIds.contains(itemId);
    }

    public Set<String> getChildrenItemIds() {
        return this._childrenItemIds;
    }

    public String getItemId() {
        return this._itemId;
    }

    public List<String> getPortletIds() {
        return this._portletIds;
    }

    public int getPosition() {
        return this._position;
    }

    public JSONObject toJSONObject() {
        return JSONUtil.put((String)"childrenItemIds", this._childrenItemIds).put("itemId", this._itemId).put("portletIds", this._portletIds).put("position", this._position);
    }
}

