"use strict";

Liferay.Loader.define("layout-admin-web@3.0.23/js/miller_columns/utils/LayoutColumnItemDropdownItems.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = void 0;
  var LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = [{
    label: Liferay.Language.get('view'),
    name: 'viewLayoutURL'
  }, {
    label: Liferay.Language.get('edit'),
    name: 'editLayoutURL'
  }, {
    label: Liferay.Language.get('configure'),
    name: 'configureURL'
  }, {
    /**
     * Handle copy layout click in order to show simple input modal.
     * @param {Event} event
     * @param {LayoutColumn} layoutColumn
     * @private
     */
    handleClick: function handleClick(event, layoutColumn) {
      event.preventDefault();
      Liferay.Util.openWindow({
        dialog: {
          destroyOnHide: true,
          height: 480,
          resizable: false,
          width: 640
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        id: event.data.item.namespace + 'addLayoutDialog',
        title: Liferay.Language.get('copy-page'),
        uri: event.data.item.href
      });
    },
    label: Liferay.Language.get('copy-page'),
    name: 'copyLayoutURL'
  }, {
    /**
     * Handle permission item click in order to open the target href in a dialog.
     * @param {Event} event
     * @private
     */
    handleClick: function handleClick(event) {
      Liferay.Util.openInDialog(Object.assign({}, event, {
        currentTarget: event.target.element
      }), {
        dialog: {
          destroyOnHide: true
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        uri: event.data.item.href
      });
    },
    label: Liferay.Language.get('permissions'),
    name: 'permissionsURL'
  }, {
    label: Liferay.Language.get('orphan-widgets'),
    name: 'orphanPortletsURL'
  }, {
    /**
     * Handle delete item click in order to show a previous confirmation alert.
     * @param {Event} event
     * @private
     */
    handleClick: function handleClick(event) {
      var deleteMessage = Liferay.Language.get('are-you-sure-you-want-to-delete-this');

      if (!confirm(deleteMessage)) {
        event.preventDefault();
      }
    },
    label: Liferay.Language.get('delete'),
    name: 'deleteURL'
  }];
  exports.LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS;
  var _default = LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS;
  exports.default = _default;
  //# sourceMappingURL=LayoutColumnItemDropdownItems.es.js.map
});
//# sourceMappingURL=LayoutColumnItemDropdownItems.es.js.map