/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.HorizontalCard;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectBasicPagesHorizontalCard
implements HorizontalCard {
    private final HttpServletRequest _httpServletRequest;
    private final LayoutTypeController _layoutTypeController;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;
    private final String _type;

    public SelectBasicPagesHorizontalCard(String type, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._type = type;
        this._renderResponse = renderResponse;
        this._layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController((String)type);
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        try {
            PortletURL addLayoutURL = this._renderResponse.createRenderURL();
            addLayoutURL.setParameter("mvcRenderCommandName", "/layout/add_layout");
            addLayoutURL.setParameter("backURL", redirect);
            long selPlid = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"selPlid");
            addLayoutURL.setParameter("selPlid", String.valueOf(selPlid));
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"privateLayout");
            addLayoutURL.setParameter("privateLayout", String.valueOf(privateLayout));
            addLayoutURL.setParameter("type", this._type);
            addLayoutURL.setWindowState(LiferayWindowState.POP_UP);
            data.put("add-layout-url", addLayoutURL.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public String getElementClasses() {
        return "add-layout-action-option card-interactive card-interactive-primary card-type-template template-card-horizontal";
    }

    public String getIcon() {
        return "page";
    }

    public String getTitle() {
        ResourceBundle layoutTypeResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._themeDisplay.getLocale(), this._layoutTypeController.getClass());
        return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (ResourceBundle)layoutTypeResourceBundle, (String)("layout.types." + this._type));
    }

    public boolean isSelectable() {
        return false;
    }
}

