/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.product.navigation.control.menu;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.util.PropsValues;
import com.liferay.product.navigation.control.menu.BaseProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=tools", "product.navigation.control.menu.entry.order:Integer=200"}, service={ProductNavigationControlMenuEntry.class})
public class ToggleControlsProductNavigationControlMenuEntry
extends BaseProductNavigationControlMenuEntry
implements ProductNavigationControlMenuEntry {
    private static final Map<String, Object> _data = Collections.singletonMap("qa-id", "showControls");

    public Map<String, Object> getData(HttpServletRequest httpServletRequest) {
        return _data;
    }

    public String getIcon(HttpServletRequest httpServletRequest) {
        String stateCss = null;
        String toggleControls = GetterUtil.getString((String)SessionClicks.get((HttpServletRequest)httpServletRequest, (String)"com.liferay.frontend.js.web_toggleControls", (String)"visible"));
        stateCss = toggleControls.equals("visible") ? "view" : "hidden";
        return stateCss;
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ((Object)((Object)this)).getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"toggle-controls");
    }

    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "toggle-controls visible-xs";
    }

    public String getURL(HttpServletRequest httpServletRequest) {
        return "javascript:;";
    }

    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return false;
        }
        Group group = layout.getGroup();
        if (group.hasStagingGroup() && !group.isStagingGroup() && PropsValues.STAGING_LIVE_GROUP_LOCKING_ENABLED) {
            return false;
        }
        if (!(this.hasUpdateLayoutPermission(themeDisplay) || this.hasCustomizePermission(themeDisplay) || this.hasPortletConfigurationPermission(themeDisplay))) {
            return false;
        }
        return super.isShow(httpServletRequest);
    }

    protected boolean hasCustomizePermission(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (!layout.isTypePortlet() || layoutTypePortlet == null) {
            return false;
        }
        if (!layoutTypePortlet.isCustomizable() || !layoutTypePortlet.isCustomizedView()) {
            return false;
        }
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"CUSTOMIZE");
    }

    protected boolean hasPortletConfigurationPermission(ThemeDisplay themeDisplay) throws PortalException {
        return PortletPermissionUtil.hasConfigurationPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getSiteGroupId(), (Layout)themeDisplay.getLayout(), (String)"CONFIGURATION");
    }

    protected boolean hasUpdateLayoutPermission(ThemeDisplay themeDisplay) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"UPDATE");
    }
}

