/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.product.navigation.control.menu;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.product.navigation.control.menu.BaseJSPProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=tools", "product.navigation.control.menu.entry.order:Integer=400"}, service={CustomizationSettingsProductNavigationControlMenuEntry.class, ProductNavigationControlMenuEntry.class})
public class CustomizationSettingsProductNavigationControlMenuEntry
extends BaseJSPProductNavigationControlMenuEntry
implements ProductNavigationControlMenuEntry {
    public static final String CUSTOMIZATION_SETTINGS_LAYOUT_UPDATE_PERMISSION = "CUSTOMIZATION_SETTINGS_LAYOUT_UPDATE_PERMISSION";
    private static final String _SHOW = CustomizationSettingsProductNavigationControlMenuEntry.class + "#_SHOW";
    private static final Log _log = LogFactoryUtil.getLog(CustomizationSettingsProductNavigationControlMenuEntry.class);

    public String getIconJspPath() {
        return "/control/menu/customization_settings.jsp";
    }

    public boolean hasUpdateLayoutPermission(ThemeDisplay themeDisplay) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"UPDATE");
    }

    public boolean includeIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            httpServletRequest.setAttribute(CUSTOMIZATION_SETTINGS_LAYOUT_UPDATE_PERMISSION, (Object)this.hasUpdateLayoutPermission(themeDisplay));
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return super.includeIcon(httpServletRequest, httpServletResponse);
    }

    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        Boolean show = (Boolean)httpServletRequest.getAttribute(_SHOW);
        if (show != null) {
            return show;
        }
        show = this._isShow(httpServletRequest);
        httpServletRequest.setAttribute(_SHOW, (Object)show);
        return show;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.layout.admin.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected boolean isCustomizableLayout(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isStagingGroup() || group.isUserGroup()) {
            return false;
        }
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        if (!layout.isTypePortlet() || layoutTypePortlet == null) {
            return false;
        }
        if (layout.isCustomizable() && this.hasUpdateLayoutPermission(themeDisplay)) {
            return true;
        }
        if (!layoutTypePortlet.isCustomizable()) {
            return false;
        }
        return LayoutPermissionUtil.containsWithoutViewableGroup((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (boolean)false, (String)"CUSTOMIZE");
    }

    private boolean _isShow(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (!this.isCustomizableLayout(themeDisplay)) {
            return false;
        }
        return super.isShow(httpServletRequest);
    }
}

