/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.layout.page.template.exception.RequiredLayoutPageTemplateEntryException;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/delete_layout_page_template_entry"}, service={MVCActionCommand.class})
public class DeleteLayoutPageTemplateEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(DeleteLayoutPageTemplateEntryMVCActionCommand.class);
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] deleteLayoutPageTemplateEntryIds = null;
        long layoutPageTemplateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryId");
        deleteLayoutPageTemplateEntryIds = layoutPageTemplateEntryId > 0L ? new long[]{layoutPageTemplateEntryId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        ArrayList<Long> deleteLayoutPageTemplateIdsList = new ArrayList<Long>();
        for (long deleteLayoutPageTemplateEntryId : deleteLayoutPageTemplateEntryIds) {
            int assetDisplayPageEntriesCount = this._assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(deleteLayoutPageTemplateEntryId);
            try {
                if (assetDisplayPageEntriesCount > 0) {
                    deleteLayoutPageTemplateIdsList.add(deleteLayoutPageTemplateEntryId);
                    SessionErrors.add((PortletRequest)actionRequest, RequiredLayoutPageTemplateEntryException.class);
                    continue;
                }
                this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(deleteLayoutPageTemplateEntryId);
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe, (Throwable)pe);
                }
                deleteLayoutPageTemplateIdsList.add(deleteLayoutPageTemplateEntryId);
            }
        }
        if (!deleteLayoutPageTemplateIdsList.isEmpty()) {
            SessionErrors.add((PortletRequest)actionRequest, PortalException.class);
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this.sendRedirect(actionRequest, actionResponse);
        }
    }
}

