/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.layout.admin.web.internal.handler.LayoutExceptionRequestHandler;
import com.liferay.layout.admin.web.internal.portlet.action.BaseAddLayoutMVCActionCommand;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplateEntryPermission;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutPrototypeService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/add_content_layout"}, service={MVCActionCommand.class})
public class AddContentLayoutMVCActionCommand
extends BaseAddLayoutMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(AddContentLayoutMVCActionCommand.class);
    @Reference
    private LayoutExceptionRequestHandler _layoutExceptionRequestHandler;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPrototypeService _layoutPrototypeService;
    @Reference
    private LayoutService _layoutService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long layoutPageTemplateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long parentLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentLayoutId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Layout layout = null;
        try {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
            if (layoutPageTemplateEntry != null && layoutPageTemplateEntry.getLayoutPrototypeId() > 0L) {
                LayoutPrototype layoutPrototype = this._layoutPrototypeService.getLayoutPrototype(layoutPageTemplateEntry.getLayoutPrototypeId());
                serviceContext.setAttribute("layoutPrototypeUuid", (Serializable)((Object)layoutPrototype.getUuid()));
                layout = this._layoutService.addLayout(groupId, privateLayout, parentLayoutId, nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "portlet", null, false, new HashMap(), serviceContext);
                SitesUtil.mergeLayoutPrototypeLayout((Group)layout.getGroup(), (Layout)layout);
            } else {
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                if (layoutPageTemplateEntryId > 0L) {
                    LayoutPageTemplateEntryPermission.check(themeDisplay.getPermissionChecker(), layoutPageTemplateEntryId, "VIEW");
                }
                layout = this._layoutService.addLayout(groupId, privateLayout, parentLayoutId, this.portal.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntryId, nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", null, false, false, new HashMap(), serviceContext);
            }
            String redirectURL = this.getRedirectURL(actionRequest, actionResponse, layout);
            if (Objects.equals(layout.getType(), "content")) {
                redirectURL = this.getContentRedirectURL(actionRequest, layout);
            }
            jsonObject.put("redirectURL", redirectURL);
            MultiSessionMessages.add((PortletRequest)actionRequest, (String)"layoutAdded", (Object)layout);
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            SessionErrors.add((PortletRequest)actionRequest, (String)"layoutNameInvalid");
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this._layoutExceptionRequestHandler.handlePortalException(actionRequest, actionResponse, pe);
        }
    }
}

