/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.handler;

import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={LayoutPageTemplateEntryExceptionRequestHandler.class})
public class LayoutPageTemplateEntryExceptionRequestHandler {
    public void handlePortalException(ActionRequest actionRequest, ActionResponse actionResponse, PortalException pe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)themeDisplay.getLocale(), LayoutPageTemplateEntryExceptionRequestHandler.class);
        String errorMessage = "an-unexpected-error-occurred";
        if (pe instanceof LayoutPageTemplateEntryNameException.MustNotBeDuplicate) {
            errorMessage = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"a-page-template-entry-with-that-name-already-exists");
        } else if (pe instanceof LayoutPageTemplateEntryNameException.MustNotBeNull) {
            errorMessage = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"name-must-not-be-empty");
        } else if (pe instanceof LayoutPageTemplateEntryNameException.MustNotContainInvalidCharacters) {
            LayoutPageTemplateEntryNameException.MustNotContainInvalidCharacters lptene = (LayoutPageTemplateEntryNameException.MustNotContainInvalidCharacters)pe;
            errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"name-cannot-contain-the-following-invalid-character-x", (Object)Character.valueOf(lptene.character));
        } else if (pe instanceof LayoutPageTemplateEntryNameException.MustNotExceedMaximumSize) {
            int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
            errorMessage = LanguageUtil.format((ResourceBundle)resourceBundle, (String)"please-enter-a-name-with-fewer-than-x-characters", (Object)nameMaxLength);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)JSONUtil.put((String)"error", (Object)errorMessage));
    }
}

