/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.handler;

import com.liferay.portal.kernel.exception.LayoutNameException;
import com.liferay.portal.kernel.exception.LayoutTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={LayoutExceptionRequestHandler.class})
public class LayoutExceptionRequestHandler {
    public void handlePortalException(ActionRequest actionRequest, ActionResponse actionResponse, PortalException pe) throws Exception {
        LayoutTypeException lte;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String errorMessage = null;
        if (pe instanceof LayoutNameException) {
            LayoutNameException lne = (LayoutNameException)pe;
            errorMessage = lne.getType() == 1 ? LanguageUtil.format((HttpServletRequest)themeDisplay.getRequest(), (String)"page-name-cannot-exceed-x-characters", (Object)ModelHintsUtil.getMaxLength((String)Layout.class.getName(), (String)"friendlyURL")) : LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"please-enter-a-valid-name-for-the-page");
        } else if (pe instanceof LayoutTypeException && ((lte = (LayoutTypeException)pe).getType() == 2 || lte.getType() == 4)) {
            errorMessage = this._handleLayoutTypeException(actionRequest, lte.getType());
        }
        if (Validator.isNull(errorMessage)) {
            errorMessage = LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"an-unexpected-error-occurred");
        }
        JSONObject jsonObject = JSONUtil.put((String)"errorMessage", errorMessage);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    private String _handleLayoutTypeException(ActionRequest actionRequest, int exceptionType) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String errorMessage = "pages-of-type-x-cannot-be-selected";
        if (exceptionType == 2) {
            errorMessage = "the-first-page-cannot-be-of-type-x";
        }
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController((String)type);
        ResourceBundle layoutTypeResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), layoutTypeController.getClass());
        String layoutTypeName = LanguageUtil.get((ResourceBundle)layoutTypeResourceBundle, (String)("layout.types." + type));
        return LanguageUtil.format((HttpServletRequest)themeDisplay.getRequest(), (String)errorMessage, (Object)layoutTypeName);
    }
}

