/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.exportimport.data.handler.util;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutPageTemplateStructureDataHandlerUtil.class})
public class LayoutPageTemplateStructureDataHandlerUtil {
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public void importLayoutPageTemplateStructure(PortletDataContext portletDataContext, long classNameId, long classPK, Element layoutPageTemplateStructureElement) throws Exception {
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)layoutPageTemplateStructureElement);
        Map layoutPageTemplateStructureIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateStructure.class);
        String path = layoutPageTemplateStructureElement.attributeValue("path");
        LayoutPageTemplateStructure layoutPageTemplateStructure = (LayoutPageTemplateStructure)portletDataContext.getZipEntryAsObject(path);
        long layoutPageTemplateStructureId = MapUtil.getLong((Map)layoutPageTemplateStructureIds, (long)layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), (long)layoutPageTemplateStructure.getLayoutPageTemplateStructureId());
        LayoutPageTemplateStructure existingLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layoutPageTemplateStructureId);
        if (existingLayoutPageTemplateStructure == null) {
            return;
        }
        existingLayoutPageTemplateStructure.setClassNameId(classNameId);
        existingLayoutPageTemplateStructure.setClassPK(classPK);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructure(existingLayoutPageTemplateStructure);
        List existingLayoutPageTemplateStructureRels = this._layoutPageTemplateStructureRelLocalService.getLayoutPageTemplateStructureRels(layoutPageTemplateStructureId);
        for (LayoutPageTemplateStructureRel existingLayoutPageTemplateStructureRel : existingLayoutPageTemplateStructureRels) {
            this._importLayoutPageTemplateStructureRel(portletDataContext, existingLayoutPageTemplateStructureRel);
            this._updateSegmentsExperiences(classNameId, classPK, existingLayoutPageTemplateStructureRel);
        }
    }

    private void _importLayoutPageTemplateStructureRel(PortletDataContext portletDataContext, LayoutPageTemplateStructureRel existingLayoutPageTemplateStructureRel) throws Exception {
        String data = existingLayoutPageTemplateStructureRel.getData();
        if (Validator.isNull((String)data)) {
            return;
        }
        JSONObject dataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
        JSONArray structureJSONArray = dataJSONObject.getJSONArray("structure");
        if (structureJSONArray == null) {
            return;
        }
        Map fragmentEntryLinkIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntryLink.class);
        for (int i = 0; i < structureJSONArray.length(); ++i) {
            JSONObject rowJSONObject = structureJSONArray.getJSONObject(i);
            JSONArray columnsJSONArray = rowJSONObject.getJSONArray("columns");
            for (int j = 0; j < columnsJSONArray.length(); ++j) {
                JSONObject columnJSONObject = columnsJSONArray.getJSONObject(j);
                JSONArray fragmentEntryLinkIdsJSONArray = columnJSONObject.getJSONArray("fragmentEntryLinkIds");
                JSONArray newFragmentEntryLinkIdsJSONArray = JSONFactoryUtil.createJSONArray();
                for (int k = 0; k < fragmentEntryLinkIdsJSONArray.length(); ++k) {
                    long fragmentEntryLinkId = MapUtil.getLong((Map)fragmentEntryLinkIds, (long)fragmentEntryLinkIdsJSONArray.getLong(k), (long)fragmentEntryLinkIdsJSONArray.getLong(k));
                    if (fragmentEntryLinkId <= 0L) continue;
                    newFragmentEntryLinkIdsJSONArray.put(fragmentEntryLinkId);
                }
                columnJSONObject.put("fragmentEntryLinkIds", newFragmentEntryLinkIdsJSONArray);
            }
        }
        existingLayoutPageTemplateStructureRel.setData(dataJSONObject.toString());
        this._layoutPageTemplateStructureRelLocalService.updateLayoutPageTemplateStructureRel(existingLayoutPageTemplateStructureRel);
    }

    private void _updateSegmentsExperiences(long classNameId, long classPK, LayoutPageTemplateStructureRel existingLayoutPageTemplateStructureRel) {
        if (existingLayoutPageTemplateStructureRel.getSegmentsExperienceId() == 0L) {
            return;
        }
        SegmentsExperience existingSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(existingLayoutPageTemplateStructureRel.getSegmentsExperienceId());
        if (existingSegmentsExperience == null) {
            return;
        }
        existingSegmentsExperience.setClassNameId(classNameId);
        existingSegmentsExperience.setClassPK(classPK);
        this._segmentsExperienceLocalService.updateSegmentsExperience(existingSegmentsExperience);
    }
}

