/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.exportimport.data.handler;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class LayoutPageTemplateEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutPageTemplateEntry> {
    public static final String[] CLASS_NAMES = new String[]{LayoutPageTemplateEntry.class.getName()};
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference(target="(model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry)", unbind="-")
    private StagedModelRepository<LayoutPageTemplateEntry> _stagedModelRepository;
    private UserLocalService _userLocalService;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(LayoutPageTemplateEntry layoutPageTemplateEntry) {
        return layoutPageTemplateEntry.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        Layout layout;
        DDMStructure ddmStructure;
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        if (layoutPageTemplateCollection != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)layoutPageTemplateCollection, (String)"parent");
        }
        if ((ddmStructure = this._ddmStructureLocalService.fetchStructure(layoutPageTemplateEntry.getClassTypeId())) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)ddmStructure, (String)"dependency");
        }
        this._exportAssetDisplayPages(portletDataContext, layoutPageTemplateEntry);
        if (layoutPageTemplateEntry.getLayoutPrototypeId() > 0L) {
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototype(layoutPageTemplateEntry.getLayoutPrototypeId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)layoutPrototype, (String)"dependency");
        }
        if ((layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid())) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)layout, (String)"dependency");
            Element layoutPageTemplateEntryElement = portletDataContext.getExportDataElement((ClassedModel)layoutPageTemplateEntry);
            portletDataContext.addReferenceElement((ClassedModel)layoutPageTemplateEntry, layoutPageTemplateEntryElement, (ClassedModel)layout, "dependency", false);
        }
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)layoutPageTemplateEntry);
        long defaultUserId = this._userLocalService.getDefaultUserId(layoutPageTemplateEntry.getCompanyId());
        if (defaultUserId == layoutPageTemplateEntry.getUserId()) {
            entryElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)layoutPageTemplateEntry), (ClassedModel)layoutPageTemplateEntry);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        long layoutPageTemplateEntryId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        String name = GetterUtil.getString((String)referenceElement.attributeValue("name"));
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        LayoutPageTemplateEntry existingLayoutPageTemplateEntry = null;
        existingLayoutPageTemplateEntry = !preloaded ? (LayoutPageTemplateEntry)this.fetchMissingReference(uuid, groupId) : this.fetchExistingTemplate(uuid, groupId, name, 0L, preloaded);
        if (existingLayoutPageTemplateEntry == null) {
            return;
        }
        Map layoutPageTemplateEntryIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateEntry.class);
        layoutPageTemplateEntryIds.put(layoutPageTemplateEntryId, existingLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long layoutPageTemplateEntryId) throws Exception {
        LayoutPageTemplateEntry existingLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this.fetchMissingReference(uuid, groupId);
        if (existingLayoutPageTemplateEntry == null) {
            return;
        }
        Map layoutPageTemplateEntryIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateEntry.class);
        layoutPageTemplateEntryIds.put(layoutPageTemplateEntryId, existingLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, LayoutPageTemplateCollection.class, (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        Map layoutPageTemplateCollectionIds = portletDataContext.getNewPrimaryKeysMap(LayoutPageTemplateCollection.class);
        long layoutPageTemplateCollectionId = MapUtil.getLong((Map)layoutPageTemplateCollectionIds, (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), (long)layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
        long classTypeId = layoutPageTemplateEntry.getClassTypeId();
        if (classTypeId > 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, DDMStructure.class, (Serializable)Long.valueOf(classTypeId));
            Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            classTypeId = MapUtil.getLong((Map)structureIds, (long)classTypeId, (long)classTypeId);
        }
        Map plids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = MapUtil.getLong((Map)plids, (long)layoutPageTemplateEntry.getPlid(), (long)layoutPageTemplateEntry.getPlid());
        LayoutPageTemplateEntry importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)layoutPageTemplateEntry.clone();
        importedLayoutPageTemplateEntry.setGroupId(portletDataContext.getScopeGroupId());
        importedLayoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        importedLayoutPageTemplateEntry.setClassTypeId(classTypeId);
        importedLayoutPageTemplateEntry.setPlid(plid);
        Element layoutPrototypeElement = portletDataContext.getReferenceDataElement((StagedModel)layoutPageTemplateEntry, LayoutPrototype.class, layoutPageTemplateEntry.getLayoutPrototypeId());
        if (layoutPrototypeElement != null) {
            String layoutPrototypePath = layoutPrototypeElement.attributeValue("path");
            LayoutPrototype layoutPrototype = (LayoutPrototype)portletDataContext.getZipEntryAsObject(layoutPrototypePath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPrototype);
            Map layoutPrototypeIds = portletDataContext.getNewPrimaryKeysMap(LayoutPrototype.class);
            long layoutPrototypeId = MapUtil.getLong((Map)layoutPrototypeIds, (long)layoutPageTemplateEntry.getLayoutPrototypeId(), (long)layoutPageTemplateEntry.getLayoutPrototypeId());
            importedLayoutPageTemplateEntry.setLayoutPrototypeId(layoutPrototypeId);
        }
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)layoutPageTemplateEntry);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            LayoutPageTemplateEntry existingLayoutPageTemplateEntry = this.fetchExistingTemplate(layoutPageTemplateEntry.getUuid(), portletDataContext.getScopeGroupId(), layoutPageTemplateEntry.getName(), plid, preloaded);
            if (existingLayoutPageTemplateEntry == null) {
                importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedLayoutPageTemplateEntry);
            } else {
                importedLayoutPageTemplateEntry.setLayoutPageTemplateEntryId(existingLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
                importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedLayoutPageTemplateEntry);
            }
        } else {
            importedLayoutPageTemplateEntry = (LayoutPageTemplateEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedLayoutPageTemplateEntry);
        }
        this._importAssetDisplayPages(portletDataContext, layoutPageTemplateEntry, importedLayoutPageTemplateEntry);
        portletDataContext.importClassedModel((ClassedModel)layoutPageTemplateEntry, (ClassedModel)importedLayoutPageTemplateEntry);
    }

    protected LayoutPageTemplateEntry fetchExistingTemplate(String uuid, long groupId, String name, long plid, boolean preloaded) {
        LayoutPageTemplateEntry existingTemplate = null;
        if (!preloaded) {
            existingTemplate = (LayoutPageTemplateEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        } else if (plid > 0L) {
            existingTemplate = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(plid);
        }
        if (existingTemplate == null && preloaded) {
            existingTemplate = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(groupId, name);
        }
        return existingTemplate;
    }

    protected StagedModelRepository<LayoutPageTemplateEntry> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private void _exportAssetDisplayPages(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortletDataException {
        List assetDisplayPageEntries = this._assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesByLayoutPageTemplateEntryId(layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        for (AssetDisplayPageEntry assetDisplayPageEntry : assetDisplayPageEntries) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPageTemplateEntry, (StagedModel)assetDisplayPageEntry, (String)"dependency");
        }
    }

    private void _importAssetDisplayPages(PortletDataContext portletDataContext, LayoutPageTemplateEntry layoutPageTemplateEntry, LayoutPageTemplateEntry importedLayoutPageTemplateEntry) throws PortletDataException {
        List assetDisplayPageEntryElements = portletDataContext.getReferenceDataElements((StagedModel)layoutPageTemplateEntry, AssetDisplayPageEntry.class);
        for (Element assetDisplayPageEntryElement : assetDisplayPageEntryElements) {
            String path = assetDisplayPageEntryElement.attributeValue("path");
            AssetDisplayPageEntry assetDisplayPageEntry = (AssetDisplayPageEntry)portletDataContext.getZipEntryAsObject(path);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)assetDisplayPageEntry);
            Map assetDisplayPageEntries = portletDataContext.getNewPrimaryKeysMap(AssetDisplayPageEntry.class);
            long assetDisplayPageEntryId = MapUtil.getLong((Map)assetDisplayPageEntries, (long)assetDisplayPageEntry.getAssetDisplayPageEntryId(), (long)assetDisplayPageEntry.getAssetDisplayPageEntryId());
            AssetDisplayPageEntry existingAssetDisplayPageEntry = this._assetDisplayPageEntryLocalService.fetchAssetDisplayPageEntry(assetDisplayPageEntryId);
            if (existingAssetDisplayPageEntry == null) continue;
            existingAssetDisplayPageEntry.setLayoutPageTemplateEntryId(importedLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            existingAssetDisplayPageEntry.setPlid(importedLayoutPageTemplateEntry.getPlid());
            this._assetDisplayPageEntryLocalService.updateAssetDisplayPageEntry(existingAssetDisplayPageEntry);
        }
    }
}

