/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class OrphanPortletsDisplayContext {
    private String _backURL;
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByType;
    private SearchContainer _orphanPortletsSearchContainer;
    private Layout _selLayout;
    private Long _selPlid;

    public OrphanPortletsDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public String getBackURL() {
        if (Validator.isNotNull((String)this._backURL)) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL");
        return this._backURL;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public List<Portlet> getOrphanPortlets() {
        Layout selLayout = this.getSelLayout();
        return this.getOrphanPortlets(selLayout);
    }

    public List<Portlet> getOrphanPortlets(Layout layout) {
        if (!layout.isSupportsEmbeddedPortlets()) {
            return Collections.emptyList();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet selLayoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        List explicitlyAddedPortlets = selLayoutTypePortlet.getExplicitlyAddedPortlets();
        ArrayList<String> explicitlyAddedPortletIds = new ArrayList<String>();
        for (Portlet explicitlyAddedPortlet : explicitlyAddedPortlets) {
            explicitlyAddedPortletIds.add(explicitlyAddedPortlet.getPortletId());
        }
        ArrayList<Portlet> orphanPortlets = new ArrayList<Portlet>();
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)layout.getPlid());
        for (PortletPreferences portletPreference : portletPreferences) {
            String portletId = portletPreference.getPortletId();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
            if (portlet.isSystem() || explicitlyAddedPortletIds.contains(portletId)) continue;
            orphanPortlets.add(portlet);
        }
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        PortletTitleComparator portletTitleComparator = new PortletTitleComparator(httpServletRequest.getServletContext(), themeDisplay.getLocale(), orderByAsc);
        orphanPortlets = ListUtil.sort(orphanPortlets, (Comparator)portletTitleComparator);
        return orphanPortlets;
    }

    public SearchContainer getOrphanPortletsSearchContainer() {
        if (this._orphanPortletsSearchContainer != null) {
            return this._orphanPortletsSearchContainer;
        }
        SearchContainer orphanPortletsSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, null);
        orphanPortletsSearchContainer.setDeltaConfigurable(false);
        orphanPortletsSearchContainer.setId("portlets");
        orphanPortletsSearchContainer.setOrderByCol("name");
        orphanPortletsSearchContainer.setOrderByType(this.getOrderByType());
        Layout selLayout = this.getSelLayout();
        if (!selLayout.isLayoutPrototypeLinkActive()) {
            orphanPortletsSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse));
        }
        List<Portlet> portlets = this.getOrphanPortlets();
        orphanPortletsSearchContainer.setResults(portlets);
        orphanPortletsSearchContainer.setTotal(portlets.size());
        this._orphanPortletsSearchContainer = orphanPortletsSearchContainer;
        return this._orphanPortletsSearchContainer;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/orphan_portlets.jsp");
        portletURL.setParameter("backURL", this.getBackURL());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public String getStatus(Portlet portlet) {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        if (!portlet.isActive()) {
            return LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"inactive");
        }
        if (!portlet.isReady()) {
            return LanguageUtil.format((HttpServletRequest)httpServletRequest, (String)"is-not-ready", (Object)"portlet");
        }
        if (portlet.isUndeployedPortlet()) {
            return LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"undeployed");
        }
        return LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"active");
    }
}

