/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplateCollectionPermission;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplatePermission;
import com.liferay.layout.admin.web.internal.util.LayoutPageTemplatePortletUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPageTemplateDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private LayoutPageTemplateCollection _layoutPageTemplateCollection;
    private Long _layoutPageTemplateCollectionId;
    private List<LayoutPageTemplateCollection> _layoutPageTemplateCollections;
    private SearchContainer _layoutPageTemplateEntriesSearchContainer;
    private LayoutPageTemplateEntry _layoutPageTemplateEntry;
    private Long _layoutPageTemplateEntryId;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public LayoutPageTemplateDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest httpServletRequest) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = httpServletRequest;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setHref(LayoutPageTemplateDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/layout/edit_layout_page_template_collection", "redirect", LayoutPageTemplateDisplayContext.this._themeDisplay.getURLCurrent()});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPageTemplateDisplayContext.this._httpServletRequest, (String)"new"));
                });
            }
        };
    }

    public List<DropdownItem> getCollectionsDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (LayoutPageTemplateCollectionPermission.contains(LayoutPageTemplateDisplayContext.this._themeDisplay.getPermissionChecker(), LayoutPageTemplateDisplayContext.this.getLayoutPageTemplateCollectionId(), "DELETE")) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "deleteCollections");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPageTemplateDisplayContext.this._httpServletRequest, (String)"delete"));
                    });
                }
            }
        };
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public LayoutPageTemplateCollection getLayoutPageTemplateCollection() throws PortalException {
        if (this._layoutPageTemplateCollection != null) {
            return this._layoutPageTemplateCollection;
        }
        this._layoutPageTemplateCollection = LayoutPageTemplateCollectionServiceUtil.fetchLayoutPageTemplateCollection((long)this.getLayoutPageTemplateCollectionId());
        return this._layoutPageTemplateCollection;
    }

    public long getLayoutPageTemplateCollectionId() {
        if (Validator.isNotNull((Long)this._layoutPageTemplateCollectionId)) {
            return this._layoutPageTemplateCollectionId;
        }
        long defaultLayoutPageTemplateCollectionId = 0L;
        List<LayoutPageTemplateCollection> layoutPageTemplateCollections = this.getLayoutPageTemplateCollections();
        if (ListUtil.isNotEmpty(layoutPageTemplateCollections)) {
            LayoutPageTemplateCollection layoutPageTemplateCollection = layoutPageTemplateCollections.get(0);
            defaultLayoutPageTemplateCollectionId = layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
        }
        this._layoutPageTemplateCollectionId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"layoutPageTemplateCollectionId", (long)defaultLayoutPageTemplateCollectionId);
        return this._layoutPageTemplateCollectionId;
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections() {
        if (this._layoutPageTemplateCollections != null) {
            return this._layoutPageTemplateCollections;
        }
        this._layoutPageTemplateCollections = LayoutPageTemplateCollectionServiceUtil.getLayoutPageTemplateCollections((long)this._themeDisplay.getScopeGroupId());
        return this._layoutPageTemplateCollections;
    }

    public SearchContainer getLayoutPageTemplateEntriesSearchContainer() {
        if (this._layoutPageTemplateEntriesSearchContainer != null) {
            return this._layoutPageTemplateEntriesSearchContainer;
        }
        SearchContainer layoutPageTemplateEntriesSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, "there-are-no-page-templates");
        layoutPageTemplateEntriesSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        layoutPageTemplateEntriesSearchContainer.setOrderByCol(this.getOrderByCol());
        OrderByComparator<LayoutPageTemplateEntry> orderByComparator = LayoutPageTemplatePortletUtil.getLayoutPageTemplateEntryOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        layoutPageTemplateEntriesSearchContainer.setOrderByComparator(orderByComparator);
        layoutPageTemplateEntriesSearchContainer.setOrderByType(this.getOrderByType());
        List layoutPageTemplateEntries = null;
        int layoutPageTemplateEntriesCount = 0;
        if (this.isSearch()) {
            layoutPageTemplateEntries = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntries((long)this._themeDisplay.getScopeGroupId(), (long)this.getLayoutPageTemplateCollectionId(), (String)this.getKeywords(), (int)layoutPageTemplateEntriesSearchContainer.getStart(), (int)layoutPageTemplateEntriesSearchContainer.getEnd(), orderByComparator);
            layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (long)this.getLayoutPageTemplateCollectionId(), (String)this.getKeywords());
        } else {
            layoutPageTemplateEntries = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntries((long)this._themeDisplay.getScopeGroupId(), (long)this.getLayoutPageTemplateCollectionId(), (int)layoutPageTemplateEntriesSearchContainer.getStart(), (int)layoutPageTemplateEntriesSearchContainer.getEnd(), orderByComparator);
            layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (long)this.getLayoutPageTemplateCollectionId());
        }
        layoutPageTemplateEntriesSearchContainer.setResults(layoutPageTemplateEntries);
        layoutPageTemplateEntriesSearchContainer.setTotal(layoutPageTemplateEntriesCount);
        this._layoutPageTemplateEntriesSearchContainer = layoutPageTemplateEntriesSearchContainer;
        return this._layoutPageTemplateEntriesSearchContainer;
    }

    public LayoutPageTemplateEntry getLayoutPageTemplateEntry() throws PortalException {
        if (this._layoutPageTemplateEntry != null) {
            return this._layoutPageTemplateEntry;
        }
        this._layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntry((long)this.getLayoutPageTemplateEntryId());
        return this._layoutPageTemplateEntry;
    }

    public long getLayoutPageTemplateEntryId() {
        if (Validator.isNotNull((Long)this._layoutPageTemplateEntryId)) {
            return this._layoutPageTemplateEntryId;
        }
        this._layoutPageTemplateEntryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"layoutPageTemplateEntryId");
        return this._layoutPageTemplateEntryId;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("tabs1", "page-templates");
        portletURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        long layoutPageTemplateCollectionId = this.getLayoutPageTemplateCollectionId();
        if (layoutPageTemplateCollectionId > 0L) {
            portletURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(layoutPageTemplateCollectionId));
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowAddButton(String actionId) {
        return LayoutPageTemplatePermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getSiteGroupId(), actionId);
    }
}

