Liferay.Loader.define("layout-admin-web@3.0.159/js/miller_columns/utils/LayoutColumnItemDropdownItems.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = void 0;

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = [{
    label: Liferay.Language.get('view'),
    name: 'viewLayoutURL'
  }, {
    label: Liferay.Language.get('edit'),
    name: 'editLayoutURL'
  }, {
    label: Liferay.Language.get('configure'),
    name: 'configureURL'
  }, {
    icons: {
      right: 'shortcut'
    },
    label: Liferay.Language.get('preview-draft'),
    name: 'previewDraftURL',
    target: '_blank'
  }, {
    label: Liferay.Language.get('approve-draft'),
    name: 'approveDraftURL'
  }, {
    /**
     * Handle copy layout click in order to show simple input modal.
     * @param {Event} event
     * @private
     */
    handleClick: function handleClick(event) {
      event.preventDefault();
      Liferay.Util.openWindow({
        dialog: {
          destroyOnHide: true,
          height: 480,
          resizable: false,
          width: 640
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        id: event.data.item.namespace + 'addLayoutDialog',
        title: Liferay.Language.get('copy-page'),
        uri: event.data.item.href
      });
    },
    label: Liferay.Language.get('copy-page'),
    name: 'copyLayoutURL'
  }, {
    /**
     * Handle permission item click in order to open the target href in a dialog.
     * @param {Event} event
     * @private
     */
    handleClick: function handleClick(event) {
      Liferay.Util.openInDialog(_objectSpread({}, event, {
        currentTarget: event.target.element
      }), {
        dialog: {
          destroyOnHide: true
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        uri: event.data.item.href
      });
    },
    label: Liferay.Language.get('permissions'),
    name: 'permissionsURL'
  }, {
    label: Liferay.Language.get('orphan-widgets'),
    name: 'orphanPortletsURL'
  }, {
    label: Liferay.Language.get('convert-to-content-page'),
    name: 'convertLayoutURL'
  }, {
    /**
     * Handle delete item click in order to show a previous confirmation alert.
     * @param {Event} event
     * @private
     */
    handleClick: function handleClick(event) {
      var deleteMessage;

      if (event.data.item.layoutColumnItem.hasChild && event.data.item.layoutColumnItem.hasScopeGroup) {
        deleteMessage = Liferay.Language.get('this-page-is-being-used-as-a-scope-for-content-and-also-has-child-pages');
      } else if (event.data.item.layoutColumnItem.hasChild) {
        deleteMessage = Liferay.Language.get('this-page-has-child-pages-that-will-also-be-removed');
      } else if (event.data.item.layoutColumnItem.hasScopeGroup) {
        deleteMessage = Liferay.Language.get('this-page-is-being-used-as-a-scope-for-content');
      } else {
        deleteMessage = Liferay.Language.get('are-you-sure-you-want-to-delete-this-page');
      }

      if (!confirm(deleteMessage)) {
        event.preventDefault();
      }
    },
    label: Liferay.Language.get('delete'),
    name: 'deleteURL'
  }];
  exports.LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS = LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS;
  var _default = LAYOUT_COLUMN_ITEM_DROPDOWN_ITEMS;
  exports["default"] = _default;
  //# sourceMappingURL=LayoutColumnItemDropdownItems.es.js.map
});
//# sourceMappingURL=LayoutColumnItemDropdownItems.es.js.map