Liferay.Loader.define("layout-admin-web@3.0.109/js/miller_columns/utils/LayoutDragDrop.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.LayoutDragDrop = exports.DROP_TARGET_ITEM_TYPES = exports.DROP_TARGET_BORDERS = void 0;

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Positions where elements can be dragged to
   * @review
   */
  var DROP_TARGET_BORDERS = {
    bottom: 'layout-column-item-drag-bottom',
    inside: 'layout-column-item-drag-inside',
    top: 'layout-column-item-drag-top'
  };
  /**
   * Possible drop target types
   * @review
   */

  exports.DROP_TARGET_BORDERS = DROP_TARGET_BORDERS;
  var DROP_TARGET_ITEM_TYPES = {
    column: 'layout-column',
    item: 'layout-column-item',
    parentable: 'layout-parentable'
  };
  /**
   * LayoutDragDrop
   */

  exports.DROP_TARGET_ITEM_TYPES = DROP_TARGET_ITEM_TYPES;

  var LayoutDragDrop = /*#__PURE__*/function (_State) {
    _inherits(LayoutDragDrop, _State);

    /**
     * @inheritDoc
     * @review
     */
    function LayoutDragDrop(config) {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, LayoutDragDrop);

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(LayoutDragDrop)).call.apply(_getPrototypeOf2, [this, config].concat(args)));

      _this._initializeDragAndDrop();

      return _this;
    }
    /**
     * @inheritDoc
     * @review
     */

    _createClass(LayoutDragDrop, [{
      key: "dispose",
      value: function dispose() {
        this._dragDrop.dispose();

        _get(_getPrototypeOf(LayoutDragDrop.prototype), "dispose", this).call(this);
      }
      /**
       * Adds a target to the list
       * @param {!HTMLElement} target
       * @review
       */

    }, {
      key: "addTarget",
      value: function addTarget(target) {
        this._dragDrop.addTarget(target);
      }
      /**
       * Callback that is executed when an item is being dragged.
       * @param {!object} data
       * @param {!MouseEvent} data.originalEvent
       * @param {!HTMLElement} data.target
       * @private
       * @review
       */

    }, {
      key: "_handleDrag",
      value: function _handleDrag(data) {
        var targetItem = data.target;

        if (targetItem) {
          var mouseY = data.originalEvent ? data.originalEvent.clientY : data.relativeY;

          var placeholderItemRegion = _metalPosition["default"].getRegion(data.placeholder);

          var sourceItemPlid = data.source.dataset.layoutColumnItemPlid;

          var targetItemRegion = _metalPosition["default"].getRegion(targetItem);

          var targetId = null;
          var targetType = null;

          if (targetItem.dataset.layoutColumnIndex) {
            targetId = targetItem.dataset.layoutColumnIndex;
            targetId = targetId === '0' ? null : targetId;
            targetType = DROP_TARGET_ITEM_TYPES.column;
          } else if (targetItem.dataset.layoutColumnItemPlid) {
            targetId = targetItem.dataset.layoutColumnItemPlid;
            targetType = DROP_TARGET_ITEM_TYPES.item;

            if (placeholderItemRegion.top > targetItemRegion.top && placeholderItemRegion.bottom < targetItemRegion.bottom && targetItem.classList.contains(DROP_TARGET_ITEM_TYPES.parentable)) {
              this._draggingItemPosition = DROP_TARGET_BORDERS.inside;
            } else if (Math.abs(mouseY - targetItemRegion.top) <= Math.abs(mouseY - targetItemRegion.bottom)) {
              this._draggingItemPosition = DROP_TARGET_BORDERS.top;
            } else {
              this._draggingItemPosition = DROP_TARGET_BORDERS.bottom;
            }
          }

          this.emit('dragLayoutColumnItem', {
            position: this._draggingItemPosition,
            sourceItemPlid: sourceItemPlid,
            targetId: targetId,
            targetType: targetType
          });
        }
      }
      /**
       * Callback that is executed when a target is leaved.
       * @private
       * @review
       */

    }, {
      key: "_handleDragEnd",
      value: function _handleDragEnd() {
        this.emit('leaveLayoutColumnItem');
      }
      /**
       * Callback that is executed when a target starts being dragged.
       * @param {object} data
       * @param {MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDragStart",
      value: function _handleDragStart(data, event) {
        var sourceItemPlid = event.target.getActiveDrag().dataset.layoutColumnItemPlid;
        this.emit('startMovingLayoutColumnItem', {
          sourceItemPlid: sourceItemPlid
        });
      }
      /**
       * Callback that is executed when an item is dropped.
       * @param {!object} data
       * @param {!HTMLElement} data.source
       * @param {HTMLElement} data.target
       * @param {!MouseEvent} event
       * @private
       * @review
       */

    }, {
      key: "_handleDrop",
      value: function _handleDrop(data, event) {
        event.preventDefault();
        var sourceItemPlid = data.source.dataset.layoutColumnItemPlid;
        var targetId = null;
        var targetType = null;

        if (data.target) {
          if (data.target.dataset.layoutColumnIndex) {
            targetId = data.target.dataset.layoutColumnIndex;
            targetId = targetId === '0' ? null : targetId;
            targetType = DROP_TARGET_ITEM_TYPES.column;
          } else if (data.target.dataset.layoutColumnItemPlid) {
            targetId = data.target.dataset.layoutColumnItemPlid;
            targetType = DROP_TARGET_ITEM_TYPES.item;
          }
        }

        this.emit('dropLayoutColumnItem', {
          sourceItemPlid: sourceItemPlid,
          targetId: targetId,
          targetType: targetType
        });
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_initializeDragAndDrop",
      value: function _initializeDragAndDrop() {
        if (this._dragDrop) {
          this._dragDrop.dispose();
        }

        this._dragDrop = new _metalDragDrop.DragDrop({
          autoScroll: true,
          dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
          handles: '.layout-drag-handler',
          scrollContainers: '.layout-column, .layout-columns',
          sources: '.layout-drag-item',
          targets: '.layout-drop-target-item'
        });

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.DRAG, this._handleDrag.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDrop.bind(this));

        this._dragDrop.on(_metalDragDrop.Drag.Events.START, this._handleDragStart.bind(this));

        this._dragDrop.on(_metalDragDrop.DragDrop.Events.TARGET_LEAVE, this._handleDragEnd.bind(this));
      }
    }]);

    return LayoutDragDrop;
  }(_metalState["default"]);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  exports.LayoutDragDrop = LayoutDragDrop;
  LayoutDragDrop.STATE = {
    /**
     * Internal DragDrop instance.
     * @default null
     * @instance
     * @memberOf LayoutDragDrop
     * @review
     * @type {object|null}
     */
    _dragDrop: _metalState.Config.internal().value(null),

    /**
     * Position of the dragging card
     * @default undefined
     * @instance
     * @memberOf LayoutDragDrop
     * @review
     * @type {!string}
     */
    _draggingItemPosition: _metalState.Config.internal().string()
  };
  var _default = LayoutDragDrop;
  exports["default"] = _default;
  //# sourceMappingURL=LayoutDragDrop.es.js.map
});
//# sourceMappingURL=LayoutDragDrop.es.js.map