Liferay.Loader.define("layout-admin-web@3.0.109/js/miller_columns/LayoutColumn.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-badge', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './LayoutColumn.soy', './utils/LayoutColumnItemDropdownItems.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.LayoutColumn = void 0;

  require("frontend-taglib-clay$clay-badge");

  require("frontend-taglib-clay$clay-dropdown");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _LayoutColumn = _interopRequireDefault(require("./LayoutColumn.soy"));

  var _LayoutColumnItemDropdownItems = _interopRequireDefault(require("./utils/LayoutColumnItemDropdownItems.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * LayoutColumn
   */
  var LayoutColumn = /*#__PURE__*/function (_Component) {
    _inherits(LayoutColumn, _Component);

    function LayoutColumn() {
      _classCallCheck(this, LayoutColumn);

      return _possibleConstructorReturn(this, _getPrototypeOf(LayoutColumn).apply(this, arguments));
    }

    _createClass(LayoutColumn, [{
      key: "prepareStateForRender",

      /**
       * @param {object} state
       * @inheritdoc
       */
      value: function prepareStateForRender(state) {
        var _this = this;

        var layoutColumn = this.layoutColumn.map(function (layoutColumnItem) {
          return _objectSpread({}, layoutColumnItem, {
            dropdownItems: LayoutColumn._getLayoutColumnItemDropDownItems(layoutColumnItem, _this.portletNamespace)
          });
        });
        return Object.assign(state, {
          layoutColumn: layoutColumn
        });
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.refs.active) {
          this.refs.active.scrollIntoView();
        }
      }
      /**
       * Handle column item dropdown item click event.
       * @param {Event} event
       */

    }, {
      key: "_handleLayoutColumnItemDropdownItemClick",
      value: function _handleLayoutColumnItemDropdownItemClick(event) {
        if (event.data && event.data.item && event.data.item.handleClick) {
          event.data.item.handleClick(event, this);
        }
      }
      /**
       * Handle column item title click event and propagate it to
       * the corresponding item mask.
       * @param {MouseEvent} event
       */

    }, {
      key: "_handleLayoutColumnItemTitleClick",
      value: function _handleLayoutColumnItemTitleClick(event) {
        var layoutItemElement = (0, _metalDom.closest)(event.delegateTarget, '.layout-item');
        var maskElement = layoutItemElement && layoutItemElement.querySelector('.layout-column-item-click-mask');

        if (maskElement) {
          maskElement.click();
        }
      }
    }], [{
      key: "_getLayoutColumnItemDropDownItems",

      /**
       * Get layout column item dropdown options
       * @param {object} layoutColumnItem
       * @return {object[]} Dropdown options
       * @review
       */
      value: function _getLayoutColumnItemDropDownItems(layoutColumnItem, namespace) {
        var _layoutColumnItem$act = layoutColumnItem.actionURLs,
            actionURLs = _layoutColumnItem$act === void 0 ? {} : _layoutColumnItem$act;

        var dropdownItems = _LayoutColumnItemDropdownItems["default"].filter(function (dropdownItem) {
          return actionURLs[dropdownItem.name];
        }).map(function (dropdownItem) {
          return {
            handleClick: dropdownItem.handleClick || null,
            href: actionURLs[dropdownItem.name],
            label: dropdownItem.label,
            layoutColumnItem: layoutColumnItem,
            namespace: namespace
          };
        });

        return dropdownItems;
      }
    }]);

    return LayoutColumn;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @type {!Object}
   * @static
   */

  exports.LayoutColumn = LayoutColumn;
  LayoutColumn.STATE = {
    /**
     * List of layouts in the current column
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!Array}
     */
    layoutColumn: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      actionURLs: _metalState.Config.object().required(),
      actions: _metalState.Config.string().required(),
      active: _metalState.Config.bool().required(),
      description: _metalState.Config.string().required(),
      hasChild: _metalState.Config.bool().required(),
      plid: _metalState.Config.string().required(),
      title: _metalState.Config.string().required(),
      url: _metalState.Config.string().required()
    })).required(),

    /**
     * URL for using icons
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!string}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Namespace of portlet to prefix parameters names
     * @default undefined
     * @instance
     * @memberof LayoutColumn
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Site navigation menu names, to add layouts by default
     * @instance
     * @memberof Layout
     * @type {!string}
     */
    siteNavigationMenuNames: _metalState.Config.string().required(),

    /**
     * CSS class to modify style
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    styleModifier: _metalState.Config.string()
  };

  _metalSoy["default"].register(LayoutColumn, _LayoutColumn["default"]);

  var _default = LayoutColumn;
  exports["default"] = _default;
  //# sourceMappingURL=LayoutColumn.es.js.map
});
//# sourceMappingURL=LayoutColumn.es.js.map