Liferay.Loader.define("layout-admin-web@2.0.60/js/utils/utils.es", ["exports"], function (exports) {
	"use strict";

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	/**
  * Recursively inserts a value inside an object creating
  * a copy of the original target. It the object (or any in the path),
  * it's an Array, it will generate new Arrays, preserving the same structure.
  *
  * @param {!Array|!Object} Original object that will be copied
  * @param {!string[]} Array of strings used for reaching the deep property
  * @param {*} value Value to be inserted
  * @return {!Array|!Object} Copy of the original object with the new value
  * @review
  */

	function setIn(object, keyPath, value) {
		var nextKey = keyPath[0];
		var target = object instanceof Array ? [].concat(_toConsumableArray(object)) : _extends({}, object);

		var nextValue = value;

		if (keyPath.length > 1) {
			nextValue = setIn(object[nextKey] || {}, keyPath.slice(1), value);
		}

		target[nextKey] = nextValue;

		return target;
	}

	exports.setIn = setIn;
});
//# sourceMappingURL=utils.es.js.map
