Liferay.Loader.define("layout-admin-web@2.0.60/js/miller_columns/Layout.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'frontend-js-web/liferay/util/navigate.es', 'metal-soy/src/Soy', './utils/LayoutDragDrop.es', './utils/LayoutUpdateUtils.es', './utils/LayoutGetUtils.es', './utils/LayoutDropUtils.es', '../utils/utils.es', './Layout.soy', './LayoutBreadcrumbs.es', './LayoutColumn.es'], function (exports, _component, _state, _navigate, _Soy, _LayoutDragDrop, _LayoutUpdateUtils, _LayoutGetUtils, _LayoutDropUtils, _utils, _Layout) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Layout = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _navigate2 = _interopRequireDefault(_navigate);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _Layout2 = _interopRequireDefault(_Layout);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Metal drag
  * @param {number}
  */
	var DRAG_SPEED = 20;

	var UPDATE_PATH_TIMEOUT = 500;

	/**
  * Component that allows to show layouts tree in form of three dependent
  * columns. It integrates three <LayoutColumn /> components for N-th, N-th + 2
  * and N-th + 3 levels of layouts tree.
  * @review
  */

	var Layout = function (_Component) {
		_inherits(Layout, _Component);

		function Layout() {
			_classCallCheck(this, Layout);

			return _possibleConstructorReturn(this, (Layout.__proto__ || Object.getPrototypeOf(Layout)).apply(this, arguments));
		}

		_createClass(Layout, [{
			key: 'attached',
			value: function attached() {
				var _this2 = this;

				this._handleLayoutColumnsScroll = this._handleLayoutColumnsScroll.bind(this);

				var A = new AUI();

				A.use('liferay-search-container', 'liferay-search-container-select', function (A) {
					var plugins = [];

					plugins.push({
						cfg: {
							rowSelector: '.layout-column'
						},
						fn: A.Plugin.SearchContainerSelect
					});

					var searchContainer = new Liferay.SearchContainer({
						contentBox: A.one(_this2.refs.layout),
						id: _this2.getInitialConfig().portletNamespace + _this2.getInitialConfig().searchContainerId,
						plugins: plugins
					});

					_this2.searchContainer_ = searchContainer;
				});
			}
		}, {
			key: 'dispose',
			value: function dispose() {
				this._layoutDragDrop.dispose();
				this._removeLayoutColumnsScrollListener();
			}
		}, {
			key: 'rendered',
			value: function rendered(firstRendered) {
				var _this3 = this;

				requestAnimationFrame(function () {
					var layoutColumns = _this3.refs.layoutColumns;


					if (typeof _this3._layoutColumnsScrollLeft === 'number') {
						layoutColumns.scrollLeft = _this3._layoutColumnsScrollLeft;
					} else {
						layoutColumns.scrollLeft = layoutColumns.scrollWidth;
					}

					if (_this3._newPathItems) {
						_this3._addLayoutDragDropTargets(_this3._newPathItems);
						_this3._newPathItems = null;
					}
				});

				if (firstRendered) {
					this._initializeLayoutDragDrop();
				}
			}
		}, {
			key: '_addLayoutColumnsScrollListener',
			value: function _addLayoutColumnsScrollListener() {
				var layoutColumns = this.refs.layoutColumns;


				if (layoutColumns) {
					this._layoutColumnsScrollLeft = layoutColumns.scrollLeft;

					layoutColumns.addEventListener('scroll', this._handleLayoutColumnsScroll);
				}
			}
		}, {
			key: '_addLayoutDragDropTargets',
			value: function _addLayoutDragDropTargets(items) {
				var _this4 = this;

				var element = null;
				var query = null;

				items.forEach(function (item) {
					query = '[data-layout-column-item-plid="' + item.plid + '"]';
					element = document.querySelector(query);
					_this4._layoutDragDrop.addTarget(element);
				});
			}
		}, {
			key: '_getItemChildren',
			value: function _getItemChildren(plid) {
				var formData = new FormData();

				formData.append(this.portletNamespace + 'plid', plid);

				return fetch(this.getItemChildrenURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				}).then(function (response) {
					return response.json();
				});
			}
		}, {
			key: '_handleDragLayoutColumnItem',
			value: function _handleDragLayoutColumnItem(eventData) {
				var _this5 = this;

				clearTimeout(this._updatePathTimeout);

				var position = eventData.position,
				    sourceItemPlid = eventData.sourceItemPlid,
				    targetId = eventData.targetId,
				    targetType = eventData.targetType;


				if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.column) {
					this._setColumnHoveredData(sourceItemPlid, targetId);
				} else if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.item) {
					this._setItemHoveredData(position, sourceItemPlid, targetId);

					if (this._draggingItemPosition === _LayoutDragDrop.DRAG_POSITIONS.inside && this._currentPathItemPlid !== targetId) {
						this._updatePathTimeout = setTimeout(function () {
							_this5._updatePath(targetId);
						}, UPDATE_PATH_TIMEOUT);
					}
				}
			}
		}, {
			key: '_handleDropLayoutColumnItem',
			value: function _handleDropLayoutColumnItem(eventData) {
				var _this6 = this;

				this._removeLayoutColumnsScrollListener();

				var layoutColumns = this.layoutColumns.map(function (layoutColumn) {
					return [].concat(_toConsumableArray(layoutColumn));
				});
				var sourceItemPlid = eventData.sourceItemPlid,
				    targetId = eventData.targetId,
				    targetType = eventData.targetType;


				var itemDropIsValid = (0, _LayoutDropUtils.dropIsValid)(this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);

				if (itemDropIsValid) {
					var parentPlid = null;
					var priority = null;

					if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.column) {
						layoutColumns = (0, _LayoutUpdateUtils.clearPath)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);

						var dropData = (0, _LayoutDropUtils.dropItemInsideColumn)(layoutColumns, this._draggingItem, targetId);

						layoutColumns = dropData.layoutColumns;
						parentPlid = dropData.newParentPlid;
						priority = dropData.priority;
					} else if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.item) {
						var targetItem = (0, _LayoutGetUtils.getItem)(layoutColumns, targetId);

						layoutColumns = (0, _LayoutUpdateUtils.clearPath)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);

						if (this._draggingItemPosition === _LayoutDragDrop.DRAG_POSITIONS.inside) {
							var pathUpdated = !!this._currentPathItemPlid;

							var _dropData = (0, _LayoutDropUtils.dropItemInsideItem)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, pathUpdated, targetItem);

							layoutColumns = _dropData.layoutColumns;
							parentPlid = _dropData.newParentPlid;
							priority = _dropData.priority;
						} else {
							var _dropData2 = (0, _LayoutDropUtils.dropItemNextToItem)(layoutColumns, this._draggingItem, this._draggingItemPosition, targetItem);

							layoutColumns = _dropData2.layoutColumns;
							parentPlid = _dropData2.newParentPlid;
							priority = _dropData2.priority;
						}
					}

					layoutColumns = (0, _LayoutUpdateUtils.setHomePage)(layoutColumns);

					this._moveLayoutColumnItemOnServer(parentPlid, sourceItemPlid, priority).then(function (response) {
						var nextPromise = response;

						if (_this6._draggingItemParentPlid !== '0') {
							nextPromise = _this6._getItemChildren(_this6._draggingItemParentPlid).then(function (response) {
								if (response.children && response.children.length === 0) {
									layoutColumns = _this6._removeHasChildArrow(layoutColumns, _this6._draggingItemParentPlid);
								}
							});
						}

						return nextPromise;
					}).then(function () {
						_this6.layoutColumns = layoutColumns;

						clearTimeout(_this6._updatePathTimeout);

						requestAnimationFrame(function () {
							_this6._initializeLayoutDragDrop();
						});
					});
				}

				this._resetHoveredData();
				this._currentPathItemPlid = null;
				this._draggingItem = null;
				this._draggingItemColumnIndex = null;
			}
		}, {
			key: '_handleLayoutColumnItemCheck',
			value: function _handleLayoutColumnItemCheck(event) {
				this._setLayoutColumnItemChecked(event.delegateTarget.value, event.delegateTarget.checked);
			}
		}, {
			key: '_handleLayoutColumnItemCheckboxClick',
			value: function _handleLayoutColumnItemCheckboxClick(event) {
				event.stopPropagation();
			}
		}, {
			key: '_handleLayoutColumnItemClick',
			value: function _handleLayoutColumnItemClick(event) {
				var targetIsA = event.target.tagName === 'A';
				var targetIsButton = event.target.tagName === 'BUTTON';

				if (!targetIsA && !targetIsButton) {
					var itemUrl = event.delegateTarget.dataset.layoutColumnItemUrl;

					if (itemUrl) {
						(0, _navigate2.default)(itemUrl);
					} else {
						var itemPlid = event.delegateTarget.dataset.layoutColumnItemPlid;

						var item = (0, _LayoutGetUtils.getItem)(this.layoutColumns, itemPlid);

						this.layoutColumns = (0, _LayoutUpdateUtils.setActiveItem)(this.layoutColumns, itemPlid);

						(0, _navigate2.default)(item.url);
					}
				}
			}
		}, {
			key: '_handleLayoutColumnsScroll',
			value: function _handleLayoutColumnsScroll() {
				var layoutColumns = this.refs.layoutColumns;


				if (layoutColumns) {
					var delta = Math.abs(this._layoutColumnsScrollLeft - layoutColumns.scrollLeft);

					if (delta <= DRAG_SPEED) {
						this._layoutColumnsScrollLeft = layoutColumns.scrollLeft;
					}
				}
			}
		}, {
			key: '_handleLeaveLayoutColumnItem',
			value: function _handleLeaveLayoutColumnItem() {
				this._resetHoveredData();
			}
		}, {
			key: '_handleStartMovingLayoutColumnItem',
			value: function _handleStartMovingLayoutColumnItem(eventData) {
				this._addLayoutColumnsScrollListener();

				var sourceItemColumn = (0, _LayoutGetUtils.getItemColumn)(this.layoutColumns, eventData.sourceItemPlid);

				var sourceItemColumnIndex = this.layoutColumns.indexOf(sourceItemColumn);

				this._draggingItem = (0, _LayoutGetUtils.getItem)(this.layoutColumns, eventData.sourceItemPlid);

				this._draggingItemColumnIndex = sourceItemColumnIndex;

				this._draggingItemParentPlid = (0, _LayoutGetUtils.getColumnActiveItem)(this.layoutColumns, sourceItemColumnIndex - 1).plid;
			}
		}, {
			key: '_initializeLayoutDragDrop',
			value: function _initializeLayoutDragDrop() {
				if (this._layoutDragDrop) {
					this._layoutDragDrop.dispose();
				}

				this._layoutDragDrop = new _LayoutDragDrop.LayoutDragDrop();

				this._layoutDragDrop.on('dragLayoutColumnItem', this._handleDragLayoutColumnItem.bind(this));

				this._layoutDragDrop.on('leaveLayoutColumnItem', this._handleLeaveLayoutColumnItem.bind(this));

				this._layoutDragDrop.on('dropLayoutColumnItem', this._handleDropLayoutColumnItem.bind(this));

				this._layoutDragDrop.on('startMovingLayoutColumnItem', this._handleStartMovingLayoutColumnItem.bind(this));
			}
		}, {
			key: '_moveLayoutColumnItemOnServer',
			value: function _moveLayoutColumnItemOnServer(parentPlid, plid, priority) {
				var _this7 = this;

				var formData = new FormData();

				formData.append(this.portletNamespace + 'plid', plid);
				formData.append(this.portletNamespace + 'parentPlid', parentPlid);

				if (priority) {
					formData.append(this.portletNamespace + 'priority', priority);
				}

				return fetch(this.moveLayoutColumnItemURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				}).catch(function () {
					_this7._resetHoveredData();
				});
			}
		}, {
			key: '_removeHasChildArrow',
			value: function _removeHasChildArrow(layoutColumns, itemPlid) {
				var nextLayoutColumns = layoutColumns;

				var column = (0, _LayoutGetUtils.getItemColumn)(layoutColumns, itemPlid);
				var item = (0, _LayoutGetUtils.getItem)(nextLayoutColumns, itemPlid);

				nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [nextLayoutColumns.indexOf(column), column.indexOf(item), 'hasChild'], false);

				this._draggingItemParentPlid = null;

				return nextLayoutColumns;
			}
		}, {
			key: '_removeLayoutColumnsScrollListener',
			value: function _removeLayoutColumnsScrollListener() {
				var layoutColumns = this.refs.layoutColumns;


				if (layoutColumns) {
					layoutColumns.removeEventListener('scroll', this._handleLayoutColumnsScroll);
				}

				this._layoutColumnsScrollLeft = null;
			}
		}, {
			key: '_resetHoveredData',
			value: function _resetHoveredData() {
				this._draggingItemPosition = null;
				this._hoveredLayoutColumnItemPlid = null;
			}
		}, {
			key: '_setColumnHoveredData',
			value: function _setColumnHoveredData(draggingItemPlid, targetColumnIndex) {
				var targetColumnIsChild = (0, _LayoutGetUtils.columnIsItemChild)(targetColumnIndex, this._draggingItem, this._draggingItemColumnIndex);
				var targetColumnLastItem = (0, _LayoutGetUtils.getColumnLastItem)(this.layoutColumns, targetColumnIndex);
				var targetEqualsSource = targetColumnLastItem && draggingItemPlid === targetColumnLastItem.plid;

				if (targetColumnLastItem && !targetColumnIsChild && !targetEqualsSource) {
					this._draggingItemPosition = _LayoutDragDrop.DRAG_POSITIONS.bottom;
					this._hoveredLayoutColumnItemPlid = targetColumnLastItem.plid;
				}
			}
		}, {
			key: '_setItemHoveredData',
			value: function _setItemHoveredData(position, sourceItemPlid, targetItemPlid) {
				var targetColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(this.layoutColumns, targetItemPlid);

				var targetIsChild = (0, _LayoutGetUtils.columnIsItemChild)(targetColumnIndex, this._draggingItem, this._draggingItemColumnIndex);

				var targetEqualsSource = sourceItemPlid === targetItemPlid;

				var draggingInsideParent = position === _LayoutDragDrop.DRAG_POSITIONS.inside && (0, _LayoutGetUtils.itemIsParent)(this.layoutColumns, sourceItemPlid, targetItemPlid);

				if (!targetEqualsSource && !targetIsChild && !draggingInsideParent) {
					this._draggingItemPosition = position;
					this._hoveredLayoutColumnItemPlid = targetItemPlid;
				}
			}
		}, {
			key: '_setLayoutColumnItemChecked',
			value: function _setLayoutColumnItemChecked(plid, checked) {
				var column = (0, _LayoutGetUtils.getItemColumn)(this.layoutColumns, plid);
				var columnIndex = this.layoutColumns.indexOf(column);
				var item = (0, _LayoutGetUtils.getItem)(this.layoutColumns, plid);

				this.layoutColumns = (0, _utils.setIn)(this.layoutColumns, [columnIndex, column.indexOf(item), 'checked'], checked);
			}
		}, {
			key: '_updatePath',
			value: function _updatePath(targetItemPlid) {
				var _this8 = this;

				var nextLayoutColumns = this.layoutColumns;

				var targetColumn = (0, _LayoutGetUtils.getItemColumn)(nextLayoutColumns, targetItemPlid);
				var targetColumnIndex = nextLayoutColumns.indexOf(targetColumn);

				nextLayoutColumns = (0, _LayoutUpdateUtils.clearFollowingColumns)(nextLayoutColumns, targetColumnIndex);

				nextLayoutColumns = (0, _LayoutUpdateUtils.setActiveItem)(nextLayoutColumns, targetItemPlid);

				this._draggingItem.active = false;

				this._currentPathItemPlid = targetItemPlid;

				nextLayoutColumns = (0, _LayoutUpdateUtils.deleteEmptyColumns)(nextLayoutColumns);

				this._getItemChildren(targetItemPlid).then(function (response) {
					var children = response.children;

					var lastColumnIndex = nextLayoutColumns.length - 1;

					if (nextLayoutColumns[lastColumnIndex].length === 0) {
						nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [lastColumnIndex], children);
					} else {
						nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [nextLayoutColumns.length], children);
					}

					_this8._newPathItems = children;

					_this8.layoutColumns = nextLayoutColumns;
				});
			}
		}]);

		return Layout;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	Layout.STATE = {

		/**
   * Breadcrumb Entries
   * @instance
   * @memberof Layout
   * @type {!Array}
   */

		breadcrumbEntries: _state.Config.arrayOf(_state.Config.shapeOf({
			title: _state.Config.string().required(),
			url: _state.Config.string().required()
		})).required(),

		/**
   * URL for get the children of an item
   * @default undefined
   * @instance
   * @review
   * @type {!string}
   */

		getItemChildrenURL: _state.Config.string().required(),

		/**
   * Layout blocks
   * @instance
   * @memberof Layout
   * @type {!Array}
   */

		layoutColumns: _state.Config.arrayOf(_state.Config.arrayOf(_state.Config.shapeOf({
			actionURLs: _state.Config.object().required(),
			active: _state.Config.bool().required(),
			checked: _state.Config.bool().required(),
			hasChild: _state.Config.bool().required(),
			homePage: _state.Config.bool().required(),
			homePageTitle: _state.Config.string().required(),
			plid: _state.Config.string().required(),
			title: _state.Config.string().required(),
			url: _state.Config.string().required()
		}))).required(),

		/**
   * URL for moving a layout column item through its column.
   * @default undefined
   * @instance
   * @review
   * @type {!string}
   */

		moveLayoutColumnItemURL: _state.Config.string().required(),

		/**
   * URL for using icons
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		pathThemeImages: _state.Config.string().required(),

		/**
   * Namespace of portlet to prefix parameters names
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Site navigation menu names, to add layouts by default
   * @instance
   * @memberof Layout
   * @type {!string}
   */

		siteNavigationMenuNames: _state.Config.string().required(),

		/**
   * Wether the path is refreshing or not
   * @default null
   * @instance
   * @review
   * @type {!string}
   */

		_currentPathItemPlid: _state.Config.string().internal().value(null),

		/**
   * Item that is being dragged.
   * @default undefined
   * @instance
   * @review
   * @type {!object}
   */

		_draggingItem: _state.Config.internal(),

		/**
   * Index of the dragging item column in layoutColumns array.
   * @default undefined
   * @instance
   * @review
   * @type {!number}
   */

		_draggingItemColumnIndex: _state.Config.number().internal(),

		/**
   * Plid of the dragging item parent
   * @default undefined
   * @instance
   * @review
   * @type {!string}
   */

		_draggingItemParentPlid: _state.Config.string().internal(),

		/**
   * Nearest border of the hovered layout column item when dragging.
   * @default undefined
   * @instance
   * @review
   * @type {!string}
   */

		_draggingItemPosition: _state.Config.string().internal(),

		/**
   * Id of the hovered layout column item when dragging.
   * @default undefined
   * @instance
   * @review
   * @type {!string}
   */

		_hoveredLayoutColumnItemPlid: _state.Config.string().internal(),

		/**
   * Scroll left position stored while dragging elements
   * @default null
   * @instance
   * @memberOf Layout
   * @private
   * @review
   * @type {number}
   */
		_layoutColumnsScrollLeft: _state.Config.internal().value(null),

		/**
   * Internal LayoutDragDrop instance
   * @default null
   * @instance
   * @memberOf Layout
   * @review
   * @type {object|null}
   */

		_layoutDragDrop: _state.Config.internal().value(null),

		/**
   * Stores new items that are shown when path is updated
   * @default null
   * @instance
   * @memberOf Layout
   * @review
   * @type {Array}
   */

		_newPathItems: _state.Config.internal().value(null),

		/**
   * Id of the timeout to update the path
   * @default undefined
   * @instance
   * @memberOf Layout
   * @review
   * @type {number}
   */

		_updatePathTimeout: _state.Config.number().internal()
	};

	_Soy2.default.register(Layout, _Layout2.default);

	exports.Layout = Layout;
	exports.default = Layout;
});
//# sourceMappingURL=Layout.es.js.map
