Liferay.Loader.define("layout-admin-web@2.0.60/js/fragments_editor/sidebar/SidebarAvailableFragments.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-drag-drop/src/all/drag', 'metal-soy/src/Soy', './SidebarAvailableFragments.soy', './FragmentsEditorSidebarCard.es'], function (exports, _component, _state, _drag, _Soy, _SidebarAvailableFragments) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SidebarAvailableFragments = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _SidebarAvailableFragments2 = _interopRequireDefault(_SidebarAvailableFragments);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var SidebarAvailableFragments = function (_Component) {
		_inherits(SidebarAvailableFragments, _Component);

		function SidebarAvailableFragments() {
			_classCallCheck(this, SidebarAvailableFragments);

			return _possibleConstructorReturn(this, (SidebarAvailableFragments.__proto__ || Object.getPrototypeOf(SidebarAvailableFragments)).apply(this, arguments));
		}

		_createClass(SidebarAvailableFragments, [{
			key: 'attached',
			value: function attached() {
				this._dragDrop = new _drag.DragDrop({
					dragPlaceholder: _drag.Drag.Placeholder.CLONE,
					handles: '.drag-handler',
					sources: '.drag-card',
					targets: '.' + this.dropTargetClass
				});

				this._dragDrop.on(_drag.DragDrop.Events.END, this._handleDrop.bind(this));
			}
		}, {
			key: 'dispose',
			value: function dispose() {
				this._dragDrop.dispose();
			}
		}, {
			key: '_handleDrop',
			value: function _handleDrop(data, event) {
				event.preventDefault();

				if (data.target) {
					var itemId = data.source.dataset.itemId;
					var itemName = data.source.dataset.itemName;

					this.emit('fragmentEntryClick', {
						fragmentEntryId: itemId,
						fragmentName: itemName
					});
				}
			}
		}, {
			key: '_handleEntryClick',
			value: function _handleEntryClick(event) {
				this.emit('fragmentEntryClick', {
					fragmentEntryId: event.itemId,
					fragmentName: event.itemName
				});
			}
		}]);

		return SidebarAvailableFragments;
	}(_component2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	SidebarAvailableFragments.STATE = {

		/**
   * CSS class for the fragments drop target.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		dropTargetClass: _state.Config.string(),

		/**
   * Available entries that can be dragged inside the existing Page Template,
   * organized by fragment categories.
   * @default undefined
   * @instance
   * @memberOf SidebarAvailableFragments
   * @type {!Array<{
   *   fragmentCollectionId: !string,
   *   fragmentEntries: Array<{
   *     fragmentEntryId: !string,
   *     imagePreviewURL: string,
   *     name: !string
   *   }>,
   *   name: !string
   * }>}
   */

		fragmentCollections: _state.Config.arrayOf(_state.Config.shapeOf({
			fragmentCollectionId: _state.Config.string().required(),
			fragmentEntries: _state.Config.arrayOf(_state.Config.shapeOf({
				fragmentEntryId: _state.Config.string().required(),
				imagePreviewURL: _state.Config.string(),
				name: _state.Config.string().required()
			}).required()).required(),
			name: _state.Config.string().required()
		})),

		/**
   * Path of the available icons.
   * @default undefined
   * @instance
   * @memberOf SidebarAvailableFragments
   * @type {!string}
   */

		spritemap: _state.Config.string().required()
	};

	_Soy2.default.register(SidebarAvailableFragments, _SidebarAvailableFragments2.default);

	exports.SidebarAvailableFragments = SidebarAvailableFragments;
	exports.default = SidebarAvailableFragments;
});
//# sourceMappingURL=SidebarAvailableFragments.es.js.map
