Liferay.Loader.define("layout-admin-web@2.0.60/js/fragments_editor/fragment_entry_link/FragmentEditableFieldTooltip.es", ['exports', 'metal-position/src/all/position', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-debounce/src/debounce', 'metal-dom/src/all/dom', 'metal-soy/src/Soy', './FragmentEditableFieldTooltip.soy'], function (exports, _position, _component, _state, _debounce, _dom, _Soy, _FragmentEditableFieldTooltip) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentEditableFieldTooltip = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _debounce2 = _interopRequireDefault(_debounce);

	var _dom2 = _interopRequireDefault(_dom);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentEditableFieldTooltip2 = _interopRequireDefault(_FragmentEditableFieldTooltip);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var FragmentEditableFieldTooltip = function (_Component) {
		_inherits(FragmentEditableFieldTooltip, _Component);

		function FragmentEditableFieldTooltip() {
			_classCallCheck(this, FragmentEditableFieldTooltip);

			return _possibleConstructorReturn(this, (FragmentEditableFieldTooltip.__proto__ || Object.getPrototypeOf(FragmentEditableFieldTooltip)).apply(this, arguments));
		}

		_createClass(FragmentEditableFieldTooltip, [{
			key: 'created',
			value: function created() {
				this._handleDocumentClick = this._handleDocumentClick.bind(this);

				this._handleWindowResize = (0, _debounce2.default)(this._handleWindowResize.bind(this), 100);

				this._windowResizeHandler = _dom2.default.on(window, 'resize', this._handleWindowResize);

				this._documentClickHandler = _dom2.default.on(document.body, 'click', this._handleDocumentClick);
			}
		}, {
			key: 'disposed',
			value: function disposed() {
				if (this._documentClickHandler) {
					this._documentClickHandler.removeListener();
					this._documentClickHandler = null;
				}

				if (this._windowResizeHandler) {
					this._windowResizeHandler.removeListener();
					this._windowResizeHandler = null;
				}
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				this._alignTooltip();
			}
		}, {
			key: '_alignTooltip',
			value: function _alignTooltip() {
				_position.Align.align(this.refs.tooltip, this.alignElement, _position.Align.Top);
			}
		}, {
			key: '_handleButtonClick',
			value: function _handleButtonClick(event) {
				var button = event.delegateTarget;
				var buttonId = button.dataset.tooltipButtonId;

				this.emit('buttonClick', { buttonId: buttonId });
			}
		}, {
			key: '_handleDocumentClick',
			value: function _handleDocumentClick(event) {
				if (this.refs.tooltip && !this.refs.tooltip.contains(event.target) && !this.alignElement.contains(event.target)) {
					this.emit('outsideTooltipClick');
				}
			}
		}, {
			key: '_handleWindowResize',
			value: function _handleWindowResize() {
				this._alignTooltip();
			}
		}]);

		return FragmentEditableFieldTooltip;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentEditableFieldTooltip.STATE = {

		/**
   * Reference element used for aligning the tooltip
   * @default undefined
   * @instance
   * @memberOf FragmentEditableFieldTooltip
   * @review
   * @type {HTMLElement}
   */

		alignElement: _state.Config.object().required(),

		/**
   * List of buttons rendered inside the tooltip
   * @default undefined
   * @instance
   * @memberOf FragmentEditableFieldTooltip
   * @review
   * @type {!Array<{
   *   id: !string,
   *   label: !string
   * }>}
   */

		buttons: _state.Config.arrayOf(_state.Config.shapeOf({
			id: _state.Config.string().required(),
			label: _state.Config.string().required()
		}))
	};

	_Soy2.default.register(FragmentEditableFieldTooltip, _FragmentEditableFieldTooltip2.default);

	exports.FragmentEditableFieldTooltip = FragmentEditableFieldTooltip;
	exports.default = FragmentEditableFieldTooltip;
});
//# sourceMappingURL=FragmentEditableFieldTooltip.es.js.map
