/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.upload;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.upload.UniqueFileNameProvider;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutPageTemplateEntryPreviewUploadFileEntryHandler.class})
public class LayoutPageTemplateEntryPreviewUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    private static final String _TEMP_FOLDER_NAME = LayoutPageTemplateEntryPreviewUploadFileEntryHandler.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateEntryPreviewUploadFileEntryHandler.class);
    @Reference(target="(model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry)")
    private ModelResourcePermission<LayoutPageTemplateEntry> _layoutPageTemplateEntryModelResourcePermission;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long layoutPageTemplateEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"layoutPageTemplateEntryId");
        this._layoutPageTemplateEntryModelResourcePermission.check(themeDisplay.getPermissionChecker(), layoutPageTemplateEntryId, "UPDATE");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            String uniqueFileName = this._uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay, (String)curFileName));
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)uniqueFileName, (InputStream)inputStream, (String)contentType);
            return fileEntry;
        }
    }

    private boolean _exists(ThemeDisplay themeDisplay, String curFileName) {
        try {
            return TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)curFileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

