/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.layout.admin.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/edit_layout_set"}, service={MVCActionCommand.class})
public class EditLayoutSetMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private ActionUtil _actionUtil;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private LayoutSetService _layoutSetService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long layoutSetId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(layoutSetId);
        this.updateLogo(actionRequest, liveGroupId, stagingGroupId, privateLayout);
        this.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layoutSet.getSettingsProperties());
        this.updateMergePages(actionRequest, liveGroupId);
        this.updateSettings(actionRequest, liveGroupId, stagingGroupId, privateLayout, layoutSet.getSettingsProperties());
    }

    protected void updateLogo(ActionRequest actionRequest, long liveGroupId, long stagingGroupId, boolean privateLayout) throws Exception {
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] logoBytes = null;
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            logoBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        long groupId = liveGroupId;
        if (stagingGroupId > 0L) {
            groupId = stagingGroupId;
        }
        this._layoutSetService.updateLogo(groupId, privateLayout, !deleteLogo, logoBytes);
    }

    protected void updateLookAndFeel(ActionRequest actionRequest, long companyId, long liveGroupId, long stagingGroupId, boolean privateLayout, UnicodeProperties typeSettingsProperties) throws Exception {
        String[] devices;
        for (String device : devices = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"devices"))) {
            String deviceThemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ThemeId"));
            String deviceColorSchemeId = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "ColorSchemeId"));
            String deviceCss = ParamUtil.getString((PortletRequest)actionRequest, (String)(device + "Css"));
            if (Validator.isNotNull((String)deviceThemeId)) {
                deviceColorSchemeId = this._actionUtil.getColorSchemeId(companyId, deviceThemeId, deviceColorSchemeId);
                this._actionUtil.updateThemeSettingsProperties(actionRequest, companyId, typeSettingsProperties, device, deviceThemeId, false);
            }
            long groupId = liveGroupId;
            if (stagingGroupId > 0L) {
                groupId = stagingGroupId;
            }
            this._layoutSetService.updateLookAndFeel(groupId, privateLayout, deviceThemeId, deviceColorSchemeId, deviceCss);
        }
    }

    protected void updateMergePages(ActionRequest actionRequest, long liveGroupId) throws Exception {
        boolean mergeGuestPublicPages = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeGuestPublicPages");
        Group liveGroup = this._groupLocalService.getGroup(liveGroupId);
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("mergeGuestPublicPages", String.valueOf(mergeGuestPublicPages));
        this._groupService.updateGroup(liveGroupId, liveGroup.getTypeSettings());
    }

    protected void updateSettings(ActionRequest actionRequest, long liveGroupId, long stagingGroupId, boolean privateLayout, UnicodeProperties settingsProperties) throws Exception {
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        settingsProperties.putAll((Map)typeSettingsProperties);
        long groupId = liveGroupId;
        if (stagingGroupId > 0L) {
            groupId = stagingGroupId;
        }
        this._layoutSetService.updateSettings(groupId, privateLayout, settingsProperties.toString());
    }
}

