/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.exception.GroupInheritContentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/delete_layout"}, service={MVCActionCommand.class})
public class DeleteLayoutMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;

    protected void deleteLayout(long selPlid, ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(selPlid);
        if (layout == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = layout.getGroup();
        if (!SitesUtil.isLayoutDeleteable((Layout)layout)) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            SessionMessages.add((PortletRequest)actionRequest, (String)(portletDisplay.getId() + ".hideDefaultErrorMessage"));
            throw new GroupInheritContentException();
        }
        if (group.isStagingGroup() && !GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)group, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)group, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException.MustHavePermission(themeDisplay.getPermissionChecker(), Group.class.getName(), group.getGroupId(), new String[]{"MANAGE_STAGING", "PUBLISH_STAGING"});
        }
        if (LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            LayoutType layoutType = layout.getLayoutType();
            EventsProcessorUtil.process((String)"layout.configuration.action.delete", (String[])layoutType.getConfigurationActionDelete(), (HttpServletRequest)this._portal.getHttpServletRequest((PortletRequest)actionRequest), (HttpServletResponse)this._portal.getHttpServletResponse((PortletResponse)actionResponse));
        }
        if (group.isGuest() && !layout.isPrivateLayout() && layout.isRootLayout() && this._layoutLocalService.getLayoutsCount(group, false, 0L) == 1) {
            throw new RequiredLayoutException(1);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        long layoutSetBranchId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        this._layoutService.deleteLayout(selPlid, serviceContext);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long selPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"selPlid");
        long[] selPlids = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        if (selPlid > 0L && ArrayUtil.isEmpty((long[])selPlids)) {
            selPlids = new long[]{selPlid};
        }
        for (long curSelPlid : selPlids) {
            this.deleteLayout(curSelPlid, actionRequest, actionResponse);
        }
    }
}

