/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.sites.kernel.util.SitesUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/copy_applications"}, service={MVCActionCommand.class})
public class CopyApplicationsMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutId;
        boolean privateLayout;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Layout layout = this._layoutLocalService.getLayout(groupId, privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout"), layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId"));
        String layoutType = layout.getType();
        if (!layoutType.equals("portlet")) {
            return;
        }
        long copyLayoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"copyLayoutId");
        if (copyLayoutId == 0L || copyLayoutId == layout.getLayoutId()) {
            return;
        }
        Layout copyLayout = this._layoutLocalService.fetchLayout(groupId, privateLayout, copyLayoutId);
        if (copyLayout == null || !copyLayout.isTypePortlet()) {
            return;
        }
        UnicodeProperties sourceLayoutTypeSettingsProperties = copyLayout.getTypeSettingsProperties();
        ActionUtil.removePortletIds((PortletRequest)actionRequest, (Layout)layout);
        ActionUtil.copyPreferences((PortletRequest)actionRequest, (Layout)layout, (Layout)copyLayout);
        SitesUtil.copyLookAndFeel((Layout)layout, (Layout)copyLayout);
        this._layoutService.updateLayout(groupId, privateLayout, layoutId, sourceLayoutTypeSettingsProperties.toString());
    }
}

