/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.AssetDisplayContributorTracker;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentCollectionServiceUtil;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryServiceUtil;
import com.liferay.fragment.util.FragmentEntryRenderUtil;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.layout.admin.web.internal.util.SoyContextFactoryUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.template.soy.utils.SoyContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FragmentsEditorDisplayContext {
    private final AssetDisplayContributorTracker _assetDisplayContributorTracker;
    private final long _classNameId;
    private final long _classPK;
    private Long _groupId;
    private final ItemSelector _itemSelector;
    private LayoutPageTemplateEntry _layoutPageTemplateEntry;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private final boolean _showMapping;
    private final ThemeDisplay _themeDisplay;

    public FragmentsEditorDisplayContext(HttpServletRequest request, RenderResponse renderResponse, String className, long classPK, boolean showMapping) {
        this._request = request;
        this._renderResponse = renderResponse;
        this._classPK = classPK;
        this._showMapping = showMapping;
        this._assetDisplayContributorTracker = (AssetDisplayContributorTracker)request.getAttribute("ASSET_DISPLAY_CONTRIBUTOR_TRACKER");
        this._classNameId = PortalUtil.getClassNameId((String)className);
        this._itemSelector = (ItemSelector)request.getAttribute("ITEM_SELECTOR");
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public SoyContext getEditorContext() throws PortalException {
        String[] languageIds;
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put((Object)"addFragmentEntryLinkURL", (Object)this._getFragmentEntryActionURL("/layout/add_fragment_entry_link"));
        SoyContext availableLanguagesSoyContext = SoyContextFactoryUtil.createSoyContext();
        for (String languageId : languageIds = LocaleUtil.toLanguageIds((Collection)LanguageUtil.getAvailableLocales((long)this._themeDisplay.getSiteGroupId()))) {
            SoyContext languageSoyContext = SoyContextFactoryUtil.createSoyContext();
            String languageIcon = StringUtil.toLowerCase((String)languageId.replace("_", "-"));
            languageSoyContext.put((Object)"languageIcon", (Object)languageIcon);
            String languageLabel = languageId.replace("_", "-");
            languageSoyContext.put((Object)"languageLabel", (Object)languageLabel);
            availableLanguagesSoyContext.put((Object)languageId, (Object)languageSoyContext);
        }
        soyContext.put((Object)"availableLanguages", (Object)availableLanguagesSoyContext);
        soyContext.put((Object)"classNameId", (Object)this._classNameId);
        soyContext.put((Object)"classPK", (Object)this._classPK);
        soyContext.put((Object)"defaultEditorConfigurations", this._getDefaultConfigurations());
        soyContext.put((Object)"defaultLanguageId", (Object)this._themeDisplay.getLanguageId());
        soyContext.put((Object)"deleteFragmentEntryLinkURL", (Object)this._getFragmentEntryActionURL("/layout/delete_fragment_entry_link"));
        soyContext.put((Object)"editFragmentEntryLinkURL", (Object)this._getFragmentEntryActionURL("/layout/edit_fragment_entry_link"));
        soyContext.put((Object)"fragmentCollections", this._getSoyContextFragmentCollections());
        soyContext.put((Object)"fragmentEntryLinks", this._getSoyContextFragmentEntryLinks());
        soyContext.put((Object)"getAssetDisplayContributorsURL", (Object)this._getFragmentEntryActionURL("/layout/get_asset_display_contributors"));
        soyContext.put((Object)"getAssetClassTypesURL", (Object)this._getFragmentEntryActionURL("/layout/get_asset_class_types"));
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._request), this._renderResponse.getNamespace() + "selectImage", new ItemSelectorCriterion[]{this._getImageItemSelectorCriterion(), this._getURLItemSelectorCriterion()});
        soyContext.put((Object)"imageSelectorURL", (Object)itemSelectorURL.toString());
        soyContext.put((Object)"languageId", (Object)this._themeDisplay.getLanguageId());
        if (this._showMapping) {
            soyContext.put((Object)"mappingFieldsURL", (Object)this._getFragmentEntryActionURL("/layout/get_mapping_fields"));
        }
        soyContext.put((Object)"portletNamespace", (Object)this._renderResponse.getNamespace());
        if (this._classNameId == PortalUtil.getClassNameId(LayoutPageTemplateEntry.class)) {
            soyContext.put((Object)"publishLayoutPageTemplateEntryURL", (Object)this._getFragmentEntryActionURL("/layout/publish_layout_page_template_entry"));
        }
        soyContext.put((Object)"renderFragmentEntryURL", (Object)this._getFragmentEntryActionURL("/layout/render_fragment_entry"));
        if (this._showMapping) {
            soyContext.put((Object)"selectedMappingTypes", (Object)this._getSelectedMappingTypes());
        }
        soyContext.put((Object)"sidebarTabs", this._getSidebarTabs());
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        soyContext.put((Object)"redirectURL", (Object)redirect);
        soyContext.put((Object)"spritemap", (Object)(this._themeDisplay.getPathThemeImages() + "/lexicon/icons.svg"));
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry();
        if (layoutPageTemplateEntry != null && layoutPageTemplateEntry.getStatus() != 0) {
            String statusLabel = WorkflowConstants.getStatusLabel((int)layoutPageTemplateEntry.getStatus());
            soyContext.put((Object)"status", (Object)LanguageUtil.get((HttpServletRequest)this._request, (String)statusLabel));
        }
        soyContext.put((Object)"updateFragmentEntryLinksURL", (Object)this._getFragmentEntryActionURL("/layout/update_fragment_entry_links"));
        soyContext.put((Object)"updateLayoutPageTemplateEntryAssetTypeURL", (Object)this._getFragmentEntryActionURL("/layout/update_layout_page_template_entry_asset_type"));
        return soyContext;
    }

    private Map<String, Object> _getDefaultConfigurations() {
        HashMap<String, Object> configurations = new HashMap<String, Object>();
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        EditorConfiguration richTextEditorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)PortletIdCodec.decodePortletName((String)portletDisplay.getId()), (String)"fragmenEntryLinkRichTextEditor", (String)"", Collections.emptyMap(), (ThemeDisplay)this._themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._request));
        configurations.put("rich-text", richTextEditorConfiguration.getData());
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)PortletIdCodec.decodePortletName((String)portletDisplay.getId()), (String)"fragmenEntryLinkEditor", (String)"", Collections.emptyMap(), (ThemeDisplay)this._themeDisplay, (RequestBackedPortletURLFactory)RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._request));
        configurations.put("text", editorConfiguration.getData());
        return configurations;
    }

    private List<SoyContext> _getFragmentEntriesSoyContext(List<FragmentEntry> fragmentEntries) {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put((Object)"fragmentEntryId", (Object)fragmentEntry.getFragmentEntryId());
            soyContext.put((Object)"imagePreviewURL", (Object)fragmentEntry.getImagePreviewURL(this._themeDisplay));
            soyContext.put((Object)"name", (Object)fragmentEntry.getName());
            soyContexts.add(soyContext);
        }
        return soyContexts;
    }

    private String _getFragmentEntryActionURL(String action) {
        PortletURL actionURL = this._renderResponse.createActionURL();
        actionURL.setParameter("javax.portlet.action", action);
        return actionURL.toString();
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId", (long)this._themeDisplay.getScopeGroupId());
        return this._groupId;
    }

    private ItemSelectorCriterion _getImageItemSelectorCriterion() {
        ArrayList<FileEntryItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<FileEntryItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new FileEntryItemSelectorReturnType());
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return imageItemSelectorCriterion;
    }

    private LayoutPageTemplateEntry _getLayoutPageTemplateEntry() throws PortalException {
        if (this._layoutPageTemplateEntry != null) {
            return this._layoutPageTemplateEntry;
        }
        this._layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntry((long)this._classPK);
        return this._layoutPageTemplateEntry;
    }

    private String _getMappingSubtypeLabel() throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry();
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)layoutPageTemplateEntry.getClassName());
        if (assetRendererFactory == null) {
            return null;
        }
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(layoutPageTemplateEntry.getClassTypeId(), this._themeDisplay.getLocale());
        return classType.getName();
    }

    private String _getMappingTypeLabel() throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry();
        AssetDisplayContributor assetDisplayContributor = this._assetDisplayContributorTracker.getAssetDisplayContributor(layoutPageTemplateEntry.getClassName());
        if (assetDisplayContributor == null) {
            return null;
        }
        return assetDisplayContributor.getLabel(this._themeDisplay.getLocale());
    }

    private SoyContext _getSelectedMappingTypes() throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._getLayoutPageTemplateEntry();
        if (layoutPageTemplateEntry == null || layoutPageTemplateEntry.getClassNameId() <= 0L) {
            return SoyContextFactoryUtil.createSoyContext();
        }
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        SoyContext typeSoyContext = SoyContextFactoryUtil.createSoyContext();
        typeSoyContext.put((Object)"id", (Object)layoutPageTemplateEntry.getClassNameId());
        typeSoyContext.put((Object)"label", (Object)this._getMappingTypeLabel());
        soyContext.put((Object)"type", (Object)typeSoyContext);
        if (layoutPageTemplateEntry.getClassTypeId() > 0L) {
            SoyContext subtypeSoyContext = SoyContextFactoryUtil.createSoyContext();
            subtypeSoyContext.put((Object)"id", (Object)layoutPageTemplateEntry.getClassTypeId());
            subtypeSoyContext.put((Object)"label", (Object)this._getMappingSubtypeLabel());
            soyContext.put((Object)"subtype", (Object)subtypeSoyContext);
        }
        return soyContext;
    }

    private List<SoyContext> _getSidebarTabs() {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        SoyContext availableSoyContext = SoyContextFactoryUtil.createSoyContext();
        availableSoyContext.put((Object)"enabled", (Object)true);
        availableSoyContext.put((Object)"id", (Object)"available");
        availableSoyContext.put((Object)"label", (Object)LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)"available"));
        soyContexts.add(availableSoyContext);
        SoyContext addedSoyContext = SoyContextFactoryUtil.createSoyContext();
        List fragmentEntryLinks = FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinks((long)this._getGroupId(), (long)this._classNameId, (long)this._classPK);
        addedSoyContext.put((Object)"enabled", (Object)(!fragmentEntryLinks.isEmpty() ? 1 : 0));
        addedSoyContext.put((Object)"id", (Object)"added");
        addedSoyContext.put((Object)"label", (Object)LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)"added"));
        soyContexts.add(addedSoyContext);
        if (this._showMapping) {
            SoyContext mappingSoyContext = SoyContextFactoryUtil.createSoyContext();
            mappingSoyContext.put((Object)"enabled", (Object)true);
            mappingSoyContext.put((Object)"id", (Object)"mapping");
            mappingSoyContext.put((Object)"label", (Object)LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)"mapping"));
            soyContexts.add(mappingSoyContext);
        }
        return soyContexts;
    }

    private List<SoyContext> _getSoyContextFragmentCollections() {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        long groupId = this._getGroupId();
        List fragmentCollections = FragmentCollectionServiceUtil.getFragmentCollections((long)groupId);
        for (FragmentCollection fragmentCollection : fragmentCollections) {
            List fragmentEntries = FragmentEntryServiceUtil.getFragmentEntries((long)groupId, (long)fragmentCollection.getFragmentCollectionId(), (int)0);
            if (ListUtil.isEmpty((List)fragmentEntries)) continue;
            SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
            soyContext.put((Object)"fragmentCollectionId", (Object)fragmentCollection.getFragmentCollectionId());
            soyContext.put((Object)"fragmentEntries", this._getFragmentEntriesSoyContext(fragmentEntries));
            soyContext.put((Object)"name", (Object)fragmentCollection.getName());
            soyContexts.add(soyContext);
        }
        return soyContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SoyContext> _getSoyContextFragmentEntryLinks() throws PortalException {
        ArrayList<SoyContext> soyContexts = new ArrayList<SoyContext>();
        List fragmentEntryLinks = FragmentEntryLinkLocalServiceUtil.getFragmentEntryLinks((long)this._getGroupId(), (long)this._classNameId, (long)this._classPK);
        boolean isolated = this._themeDisplay.isIsolated();
        this._themeDisplay.setIsolated(true);
        try {
            for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
                FragmentEntry fragmentEntry = FragmentEntryServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
                SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
                soyContext.putHTML("content", FragmentEntryRenderUtil.renderFragmentEntryLink((FragmentEntryLink)fragmentEntryLink, (HttpServletRequest)this._request, (HttpServletResponse)PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse)));
                soyContext.put((Object)"editableValues", (Object)JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues()));
                soyContext.put((Object)"fragmentEntryId", (Object)fragmentEntry.getFragmentEntryId());
                soyContext.put((Object)"fragmentEntryLinkId", (Object)String.valueOf(fragmentEntryLink.getFragmentEntryLinkId()));
                soyContext.put((Object)"name", (Object)fragmentEntry.getName());
                soyContext.put((Object)"position", (Object)fragmentEntryLink.getPosition());
                soyContexts.add(soyContext);
            }
        }
        finally {
            this._themeDisplay.setIsolated(isolated);
        }
        return soyContexts;
    }

    private ItemSelectorCriterion _getURLItemSelectorCriterion() {
        URLItemSelectorCriterion urlItemSelectorCriterion = new URLItemSelectorCriterion();
        ArrayList<URLItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<URLItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new URLItemSelectorReturnType());
        urlItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return urlItemSelectorCriterion;
    }
}

