Liferay.Loader.define("layout-admin-web@2.0.15/js/fragments_editor/dialogs/SelectMappingTypeDialog.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-soy/src/Soy', './SelectMappingTypeDialog.soy', 'frontend-js-web/liferay/compat/modal/Modal.es'], function (exports, _component, _state, _Soy, _SelectMappingTypeDialog) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SelectMappingTypeDialog = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _SelectMappingTypeDialog2 = _interopRequireDefault(_SelectMappingTypeDialog);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var SelectMappingTypeDialog = function (_Component) {
		_inherits(SelectMappingTypeDialog, _Component);

		function SelectMappingTypeDialog() {
			_classCallCheck(this, SelectMappingTypeDialog);

			return _possibleConstructorReturn(this, (SelectMappingTypeDialog.__proto__ || Object.getPrototypeOf(SelectMappingTypeDialog)).apply(this, arguments));
		}

		_createClass(SelectMappingTypeDialog, [{
			key: 'rendered',
			value: function rendered() {
				if (this.visible && !this._mappingTypes) {
					this._loadMappingTypes();
				}

				if (this._mappingTypes && this._mappingTypes.length === 1 && !this._selectedMappingTypeId) {
					this._handleMappingTypeSelectChange();
				}

				if (this._mappingSubtypes && this._mappingSubtypes.length === 1 && !this._selectedMappingSubtypeId) {
					this._handleMappingSubtypeSelectChange();
				}
			}
		}, {
			key: '_emitSelectedMappingLabels',
			value: function _emitSelectedMappingLabels() {
				var _this2 = this;

				var mappingTypes = {};
				var subtype = this._mappingSubtypes.find(function (subtype) {
					return subtype.id === _this2._selectedMappingSubtypeId;
				});
				var type = this._mappingTypes.find(function (type) {
					return type.id === _this2._selectedMappingTypeId;
				});

				if (subtype) {
					mappingTypes.subtype = {
						id: this._selectedMappingSubtypeId,
						label: subtype.label
					};
				}

				if (type) {
					mappingTypes.type = {
						id: this._selectedMappingTypeId,
						label: type.label
					};
				}

				this.emit('mappingTypeSelected', { mappingTypes: mappingTypes });
			}
		}, {
			key: '_handleCloseButtonClick',
			value: function _handleCloseButtonClick() {
				this.visible = false;
			}
		}, {
			key: '_handleMappingSubtypeSelectChange',
			value: function _handleMappingSubtypeSelectChange() {
				var selectInput = this.refs.modal.refs.selectMappingSubtype;

				var mappingSubtype = this._mappingSubtypes.find(function (mappingSubtype) {
					return mappingSubtype.id === selectInput.value;
				});

				this._selectedMappingSubtypeId = mappingSubtype.id;
			}
		}, {
			key: '_handleMappingTypeSelectChange',
			value: function _handleMappingTypeSelectChange() {
				var selectInput = this.refs.modal.refs.selectMappingType;

				var mappingType = this._mappingTypes.find(function (mappingType) {
					return mappingType.id === selectInput.value;
				});

				this._selectedMappingTypeId = mappingType.id;
				this._mappingSubtypes = [];

				this._loadMappingSubtypes();
			}
		}, {
			key: '_handleSubmitButtonClick',
			value: function _handleSubmitButtonClick() {
				var _this3 = this;

				this._savingChanges = true;

				var formData = new FormData();

				formData.append(this.portletNamespace + 'classPK', this.classPK);

				formData.append(this.portletNamespace + 'classNameId', this._selectedMappingTypeId);

				formData.append(this.portletNamespace + 'classTypeId', this._selectedMappingSubtypeId);

				return fetch(this.updateLayoutPageTemplateEntryAssetTypeURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				}).then(function (response) {
					return response.json();
				}).then(function () {
					_this3._emitSelectedMappingLabels();
					_this3.visible = false;
				});
			}
		}, {
			key: '_handleVisibleChanged',
			value: function _handleVisibleChanged(change) {
				if (this.visible !== change.newVal) {
					this.visible = change.newVal;
				}

				if (!change.newVal) {
					this._mappingSubtypes = [];
					this._mappingTypes = [];
					this._savingChanges = false;
					this._selectedMappingTypeId = '';
					this._selectedMappingSubtypeId = '';
				}
			}
		}, {
			key: '_loadMappingSubtypes',
			value: function _loadMappingSubtypes() {
				var _this4 = this;

				this._mappingSubtypes = null;

				var formData = new FormData();

				formData.append(this.portletNamespace + 'classNameId', this._selectedMappingTypeId);

				return fetch(this.getAssetClassTypesURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				}).then(function (response) {
					return response.json();
				}).then(function (response) {
					_this4._mappingSubtypes = response;
				});
			}
		}, {
			key: '_loadMappingTypes',
			value: function _loadMappingTypes() {
				var _this5 = this;

				return fetch(this.getAssetDisplayContributorsURL, {
					credentials: 'include',
					method: 'POST'
				}).then(function (response) {
					return response.json();
				}).then(function (response) {
					_this5._mappingTypes = response;
				});
			}
		}]);

		return SelectMappingTypeDialog;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	SelectMappingTypeDialog.STATE = {

		/**
   * Class primary key used for storing changes.
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		classPK: _state.Config.string().required(),

		/**
   * URL for obtaining the asset types for which asset display pages can be
   * created.
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		getAssetClassTypesURL: _state.Config.string().required(),

		/**
   * URL for obtaining the asset types for which asset display pages can be
   * created.
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		getAssetDisplayContributorsURL: _state.Config.string().required(),

		/**
   * Portlet namespace needed for prefixing form inputs
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Path of the available icons.
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		spritemap: _state.Config.string().required(),

		/**
   * URL for updating the asset type associated to a template.
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!string}
   */

		updateLayoutPageTemplateEntryAssetTypeURL: _state.Config.string().required(),

		/**
   * Whether to show the mapping dialog or not
   * @default undefined
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @review
   * @type {!boolean}
   */

		visible: _state.Config.bool().required(),

		/**
   * List of available mapping types
   * @default null
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @private
   * @review
   * @type {Array<{
   *   id: !string,
   *   label: !string
   * }>}
   */

		_mappingTypes: _state.Config.arrayOf(_state.Config.shapeOf({
			id: _state.Config.string().required(),
			label: _state.Config.string().required()
		})).value(null),

		/**
   * List of available mapping subtypes
   * @default null
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @private
   * @review
   * @type {Array<{
   *   id: !string,
   *   label: !string
   * }>}
   */

		_mappingSubtypes: _state.Config.arrayOf(_state.Config.shapeOf({
			id: _state.Config.string().required(),
			label: _state.Config.string().required()
		})).value([]),

		/**
   * Flag indicating if changes are being sent to the server
   * @default false
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @private
   * @review
   * @type {boolean}
   */

		_savingChanges: _state.Config.bool().internal().value(false),

		/**
   * String with the selected mapping type id
   * @default ''
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @private
   * @review
   * @type {string}
   */

		_selectedMappingTypeId: _state.Config.string().internal().value(''),

		/**
   * String with the selected mapping subtype id
   * @default ''
   * @instance
   * @memberOf SelectMappingTypeDialog
   * @private
   * @review
   * @type {string}
   */

		_selectedMappingSubtypeId: _state.Config.string().internal().value('')

	};

	_Soy2.default.register(SelectMappingTypeDialog, _SelectMappingTypeDialog2.default);

	exports.SelectMappingTypeDialog = SelectMappingTypeDialog;
	exports.default = SelectMappingTypeDialog;
});
//# sourceMappingURL=SelectMappingTypeDialog.es.js.map
