/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.upgrade.v_1_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateLayouts();
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        if (Validator.isNull((String)typeSettings)) {
            return;
        }
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.load(typeSettings);
        typeSettingsProperties.setProperty("embeddedLayoutURL", typeSettingsProperties.getProperty("url"));
        typeSettingsProperties.remove((Object)"url");
        this.updateTypeSettings(plid, typeSettingsProperties.toString());
    }

    protected void updateLayouts() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select plid, typeSettings from Layout where type_ = ?");){
            ps.setString(1, "embedded");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long plid = rs.getLong("plid");
                    String typeSettings = rs.getString("typeSettings");
                    this.updateLayout(plid, typeSettings);
                }
            }
        }
    }

    protected void updateTypeSettings(long plid, String typeSettings) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = ?");){
            ps.setString(1, typeSettings);
            ps.setLong(2, plid);
            ps.executeUpdate();
        }
    }
}

