/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.theme.contributor;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"type=THEME"}, service={TemplateContextContributor.class})
public class ToggleControlsTemplateContextContributor
implements TemplateContextContributor {
    public void prepare(Map<String, Object> contextObjects, HttpServletRequest request) {
        String liferayToggleControls = SessionClicks.get((HttpServletRequest)request, (String)"com.liferay.frontend.js.web_toggleControls", (String)"visible");
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            liferayToggleControls = "visible";
        }
        String cssClass = GetterUtil.getString((Object)contextObjects.get("bodyCssClass"));
        cssClass = Objects.equals(liferayToggleControls, "visible") ? cssClass + " controls-visible" : cssClass + " controls-hidden";
        contextObjects.put("bodyCssClass", cssClass);
        contextObjects.put("liferay_toggle_controls", liferayToggleControls);
        contextObjects.put("show_toggle_controls", themeDisplay.isSignedIn());
        if (themeDisplay.isSignedIn()) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
            contextObjects.put("toggle_controls_text", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"toggle-controls"));
            contextObjects.put("toggle_controls_url", "javascript:;");
        }
    }
}

