/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.layout.admin.web.internal.handler.LayoutPageTemplateEntryExceptionRequestHandler;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/add_layout_page_template_entry"}, service={MVCActionCommand.class})
public class AddLayoutPageTemplateEntryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private LayoutPageTemplateEntryExceptionRequestHandler _layoutPageTemplateEntryExceptionRequestHandler;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutPageTemplateCollectionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPageTemplateCollectionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)0);
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(serviceContext.getScopeGroupId(), layoutPageTemplateCollectionId, name, type, 2, serviceContext);
            if (SessionErrors.contains((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryNameInvalid")) {
                this.addSuccessMessage(actionRequest, actionResponse);
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("redirectURL", this.getRedirectURL(actionRequest, actionResponse, layoutPageTemplateEntry));
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        catch (PortalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryNameInvalid");
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this._layoutPageTemplateEntryExceptionRequestHandler.handlePortalException(actionRequest, actionResponse, pe);
        }
    }

    protected String getRedirectURL(ActionRequest actionRequest, ActionResponse actionResponse, LayoutPageTemplateEntry layoutPageTemplateEntry) {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/layout/edit_layout_page_template_entry");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId()));
        portletURL.setParameter("layoutPageTemplateEntryId", String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return portletURL.toString();
    }
}

