/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.PortletTitleComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class OrphanPortletsDisplayContext {
    private String _backURL;
    private String _displayStyle;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private final HttpServletRequest _request;
    private Layout _selLayout;
    private Long _selPlid;

    public OrphanPortletsDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteOrphanPortlets");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)OrphanPortletsDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getBackURL() {
        if (Validator.isNotNull((String)this._backURL)) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((HttpServletRequest)this._request, (String)"backURL");
        return this._backURL;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(OrphanPortletsDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)OrphanPortletsDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(OrphanPortletsDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)OrphanPortletsDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public List<Portlet> getOrphanPortlets() {
        Layout selLayout = this.getSelLayout();
        return this.getOrphanPortlets(selLayout);
    }

    public List<Portlet> getOrphanPortlets(Layout layout) {
        if (!layout.isSupportsEmbeddedPortlets()) {
            return Collections.emptyList();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LayoutTypePortlet selLayoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        List explicitlyAddedPortlets = selLayoutTypePortlet.getExplicitlyAddedPortlets();
        ArrayList<String> explicitlyAddedPortletIds = new ArrayList<String>();
        for (Portlet explicitlyAddedPortlet : explicitlyAddedPortlets) {
            explicitlyAddedPortletIds.add(explicitlyAddedPortlet.getPortletId());
        }
        ArrayList<Portlet> orphanPortlets = new ArrayList<Portlet>();
        List portletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)layout.getPlid());
        for (PortletPreferences portletPreference : portletPreferences) {
            String portletId = portletPreference.getPortletId();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
            if (portlet.isSystem() || explicitlyAddedPortletIds.contains(portletId)) continue;
            orphanPortlets.add(portlet);
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        PortletTitleComparator portletTitleComparator = new PortletTitleComparator(request.getServletContext(), themeDisplay.getLocale(), orderByAsc);
        orphanPortlets = ListUtil.sort(orphanPortlets, (Comparator)portletTitleComparator);
        return orphanPortlets;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/orphan_portlets.jsp");
        portletURL.setParameter("backURL", this.getBackURL());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public String getStatus(Portlet portlet) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        if (!portlet.isActive()) {
            return LanguageUtil.get((HttpServletRequest)request, (String)"inactive");
        }
        if (!portlet.isReady()) {
            return LanguageUtil.format((HttpServletRequest)request, (String)"is-not-ready", (Object)"portlet");
        }
        if (portlet.isUndeployedPortlet()) {
            return LanguageUtil.get((HttpServletRequest)request, (String)"undeployed");
        }
        return LanguageUtil.get((HttpServletRequest)request, (String)"active");
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)OrphanPortletsDisplayContext.this.getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)OrphanPortletsDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(OrphanPortletsDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(OrphanPortletsDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)OrphanPortletsDisplayContext.this._request, (String)"name"));
                });
            }
        };
    }
}

